/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import COM.claymoresystems.cert.X509Name;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.ptls.PureTLSUtil;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GlobusGSSName
implements GSSName,
Serializable {
    protected Oid nameType;
    protected X509Name name;
    protected String globusID;

    public GlobusGSSName() {
        this.nameType = GSSName.NT_ANONYMOUS;
        this.name = null;
    }

    public GlobusGSSName(X509Name name) {
        if (name == null) {
            this.nameType = GSSName.NT_ANONYMOUS;
        }
        this.name = name;
    }

    public GlobusGSSName(byte[] name) {
        if (name == null) {
            this.nameType = GSSName.NT_ANONYMOUS;
            this.name = null;
        } else {
            this.name = new X509Name(name);
        }
    }

    public GlobusGSSName(String name) throws GSSException {
        if (name == null) {
            this.nameType = GSSName.NT_ANONYMOUS;
            this.name = null;
        } else {
            try {
                this.name = PureTLSUtil.getX509Name(name);
            }
            catch (Exception e) {
                throw new GlobusGSSException(3, (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GlobusGSSName(String name, Oid nameType) throws GSSException {
        if (name == null) {
            if (nameType != null && !nameType.equals(GSSName.NT_ANONYMOUS)) {
                throw new GSSException(4);
            }
            this.name = null;
            this.nameType = GSSName.NT_ANONYMOUS;
            return;
        }
        if (nameType != null) {
            if (!nameType.equals(GSSName.NT_HOSTBASED_SERVICE)) throw new GSSException(4);
            int atPos = name.indexOf(64);
            if (atPos == -1 || atPos + 1 >= name.length()) {
                throw new GlobusGSSException(11, 25, "badName00");
            }
            String host = name.substring(atPos + 1);
            try {
                InetAddress i = InetAddress.getByName(host);
                host = InetAddress.getByName(i.getHostAddress()).getHostName();
            }
            catch (UnknownHostException e) {
                throw new GlobusGSSException(11, (Throwable)e);
            }
            String[] ava = new String[]{"CN", String.valueOf(name.substring(0, atPos)) + "/" + host};
            Vector<String[]> rdn = new Vector<String[]>(1);
            rdn.addElement(ava);
            Vector<Vector<String[]>> dn = new Vector<Vector<String[]>>(1);
            dn.addElement(rdn);
            this.name = new X509Name(dn);
        } else {
            try {
                this.name = PureTLSUtil.getX509Name(name);
            }
            catch (Exception e) {
                throw new GlobusGSSException(3, (Throwable)e);
            }
        }
        this.nameType = nameType;
    }

    @Override
    public boolean isAnonymous() {
        return this.name == null;
    }

    @Override
    public boolean isMN() {
        return true;
    }

    @Override
    public boolean equals(GSSName another) throws GSSException {
        if (another == null) {
            return false;
        }
        if (this.isAnonymous()) {
            return another.isAnonymous();
        }
        if (another.isAnonymous()) {
            return false;
        }
        if (!(another instanceof GlobusGSSName)) {
            throw new GSSException(11);
        }
        GlobusGSSName other = (GlobusGSSName)another;
        if (this.nameType != null && this.nameType.equals(GSSName.NT_HOSTBASED_SERVICE) || other.nameType != null && other.nameType.equals(GSSName.NT_HOSTBASED_SERVICE)) {
            int i2;
            String service2;
            String hp1 = this.getHostPart(true);
            String hp2 = other.getHostPart(true);
            if (hp1 == null || hp2 == null) {
                return false;
            }
            String service1 = GlobusGSSName.getService(hp1);
            if (!service1.equalsIgnoreCase(service2 = GlobusGSSName.getService(hp2))) {
                return false;
            }
            String host1 = GlobusGSSName.getHost(hp1);
            String host2 = GlobusGSSName.getHost(hp2);
            int i1 = 0;
            int s1 = host1.length();
            int s2 = host2.length();
            for (i2 = 0; i1 < s1 && i2 < s2; ++i1, ++i2) {
                char h2;
                char h1 = Character.toUpperCase(host1.charAt(i1));
                if (h1 == (h2 = Character.toUpperCase(host2.charAt(i2)))) {
                    if (h1 != '.') continue;
                    return host1.equalsIgnoreCase(host2);
                }
                if (h1 == '.' && h2 == '-') {
                    return GlobusGSSName.compareHost(host2, i2, host1, i1);
                }
                if (h1 == '-' && h2 == '.') {
                    return GlobusGSSName.compareHost(host1, i1, host2, i2);
                }
                return false;
            }
            return i1 == i2;
        }
        return this.toString().equalsIgnoreCase(another.toString());
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return "<anonymous>";
        }
        if (this.globusID == null) {
            this.globusID = PureTLSUtil.toGlobusID(this.name);
        }
        return this.globusID;
    }

    protected String getHostPart(boolean first) {
        Vector dn = this.name.getName();
        int len = dn.size();
        if (first) {
            int i = 0;
            while (i < len) {
                Vector rdn = (Vector)dn.elementAt(i);
                String[] ava = (String[])rdn.elementAt(0);
                if (ava[0].equalsIgnoreCase("CN")) {
                    return ava[1];
                }
                ++i;
            }
        } else {
            int i = len - 1;
            while (i >= 0) {
                Vector rdn = (Vector)dn.elementAt(i);
                String[] ava = (String[])rdn.elementAt(0);
                if (ava[0].equalsIgnoreCase("CN")) {
                    return ava[1];
                }
                --i;
            }
        }
        return null;
    }

    private static String getService(String name) {
        int pos = name.indexOf(47);
        return pos == -1 ? "host" : name.substring(0, pos);
    }

    private static String getHost(String name) {
        int pos = name.indexOf(47);
        return pos == -1 ? name : name.substring(pos + 1);
    }

    private static boolean compareHost(String host1, int i, String host2, int j) {
        if (host1.charAt(i) != '-') {
            throw new IllegalArgumentException();
        }
        int size = host1.length();
        while (i < size) {
            if (host1.charAt(i) == '.') break;
            ++i;
        }
        if (size - i == host2.length() - j) {
            return host1.regionMatches(i, host2, j, size - i);
        }
        return false;
    }

    @Override
    public Oid getStringNameType() throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public byte[] export() throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public GSSName canonicalize(Oid mech) throws GSSException {
        throw new GSSException(16);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.nameType);
        Vector oids = this.name.getName();
        oos.writeObject(oids);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.nameType = (Oid)ois.readObject();
        this.name = new X509Name((Vector)ois.readObject());
    }
}

