/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.globus.gsi.SigningPolicyParser;

public class SigningPolicy {
    private Vector patterns;
    private String caDN;
    private String fileName;

    public SigningPolicy(String caDN_) {
        this(caDN_, null);
    }

    public SigningPolicy(String caDN_, Vector patterns_) {
        this(caDN_, patterns_, null);
    }

    public SigningPolicy(String caDN_, Vector patterns_, String fileName_) {
        if (caDN_ == null || caDN_.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        this.caDN = caDN_;
        this.patterns = patterns_;
        this.fileName = fileName_;
    }

    public Vector getPatterns() {
        return this.patterns;
    }

    public String getCaSubject() {
        return this.caDN;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName_) {
        this.fileName = fileName_;
    }

    public boolean isPolicyAvailable() {
        return this.patterns != null && this.patterns.size() >= 1;
    }

    public boolean isValidSubject(String subjectDN) {
        if (subjectDN == null) {
            throw new IllegalArgumentException();
        }
        if (this.patterns == null || this.patterns.size() < 1) {
            return true;
        }
        subjectDN = SigningPolicyParser.normalizeDN(subjectDN);
        int size = this.patterns.size();
        int i = 0;
        while (i < size) {
            Pattern pattern = (Pattern)this.patterns.get(i);
            Matcher matcher = pattern.matcher(subjectDN);
            boolean valid = matcher.matches();
            if (valid) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

