/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.globus.util.Base64;
import org.globus.util.I18n;

public class GlobusCredential
implements Serializable {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", CertUtil.class.getClassLoader());
    private static Log logger = LogFactory.getLog(GlobusCredential.class.getName());
    private static transient GlobusCredential defaultCred = null;
    private static transient boolean credentialSet = false;
    private static transient File credentialFile = null;
    private static transient long credentialLastModified = -1L;
    private PrivateKey key;
    private X509Certificate[] certs;

    public GlobusCredential(PrivateKey key, X509Certificate[] certs) {
        this.key = key;
        this.certs = certs;
    }

    public GlobusCredential(String proxyFile) throws GlobusCredentialException {
        if (proxyFile == null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyFileNull"));
        }
        logger.debug("Loading proxy file: " + proxyFile);
        try {
            FileInputStream in = new FileInputStream(proxyFile);
            this.load(in);
        }
        catch (FileNotFoundException f) {
            throw new GlobusCredentialException(3, "proxyNotFound", new Object[]{proxyFile});
        }
    }

    public GlobusCredential(String certFile, String unencryptedKeyFile) throws GlobusCredentialException {
        if (certFile == null || unencryptedKeyFile == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.certs = CertUtil.loadCertificates(certFile);
            BouncyCastleOpenSSLKey k = new BouncyCastleOpenSSLKey(unencryptedKeyFile);
            if (k.isEncrypted()) {
                throw new GlobusCredentialException(2, "encPrivKey", new Object[]{unencryptedKeyFile});
            }
            this.key = k.getPrivateKey();
        }
        catch (IOException e) {
            throw new GlobusCredentialException(3, "ioError00", e);
        }
        catch (GeneralSecurityException e) {
            throw new GlobusCredentialException(3, "secError00", e);
        }
        catch (Exception e) {
            throw new GlobusCredentialException(-1, "error00", e);
        }
    }

    public GlobusCredential(InputStream input) throws GlobusCredentialException {
        this.load(input);
    }

    protected void load(InputStream input) throws GlobusCredentialException {
        if (input == null) {
            String err = i18n.getMessage("credInpStreamNull");
            throw new IllegalArgumentException(err);
        }
        PrivateKey key = null;
        X509Certificate cert = null;
        Vector<X509Certificate> chain = new Vector<X509Certificate>(3);
        BufferedReader reader = null;
        try {
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(input));
                while ((line = reader.readLine()) != null) {
                    byte[] data;
                    if (line.indexOf("BEGIN CERTIFICATE") != -1) {
                        data = GlobusCredential.getDecodedPEMObject(reader);
                        cert = CertUtil.loadCertificate(new ByteArrayInputStream(data));
                        chain.addElement(cert);
                        continue;
                    }
                    if (line.indexOf("BEGIN RSA PRIVATE KEY") == -1) continue;
                    data = GlobusCredential.getDecodedPEMObject(reader);
                    BouncyCastleOpenSSLKey k = new BouncyCastleOpenSSLKey("RSA", data);
                    key = k.getPrivateKey();
                }
            }
            catch (IOException e) {
                throw new GlobusCredentialException(3, "ioError00", e);
            }
            catch (GeneralSecurityException e) {
                throw new GlobusCredentialException(3, "secError00", e);
            }
            catch (Exception e) {
                throw new GlobusCredentialException(-1, "error00", e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        int size = chain.size();
        if (size == 0) {
            throw new GlobusCredentialException(3, "noCerts00", null);
        }
        if (key == null) {
            throw new GlobusCredentialException(3, "noKey00", null);
        }
        this.certs = new X509Certificate[size];
        chain.copyInto(this.certs);
        this.key = key;
    }

    private static final byte[] getDecodedPEMObject(BufferedReader reader) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("--END") != -1) {
                return Base64.decode(buf.toString().getBytes());
            }
            buf.append(line);
        }
        throw new EOFException(i18n.getMessage("pemFooter"));
    }

    public void save(OutputStream out) throws IOException {
        try {
            CertUtil.writeCertificate(out, this.certs[0]);
            BouncyCastleOpenSSLKey k = new BouncyCastleOpenSSLKey(this.key);
            k.writeTo(out);
            int i = 1;
            while (i < this.certs.length) {
                if (!this.certs[i].getSubjectDN().equals(this.certs[i].getIssuerDN())) {
                    CertUtil.writeCertificate(out, this.certs[i]);
                }
                ++i;
            }
        }
        catch (CertificateEncodingException e) {
            throw new ChainedIOException(e.getMessage(), e);
        }
        out.flush();
    }

    public void verify() throws GlobusCredentialException {
        ProxyPathValidator validator = new ProxyPathValidator();
        try {
            TrustedCertificates trustedCerts = TrustedCertificates.getDefault();
            validator.validate(this.getCertificateChain(), trustedCerts.getCertificates(), CertificateRevocationLists.getDefault(), trustedCerts.getSigningPolicies());
        }
        catch (ProxyPathValidatorException e) {
            if (e.getMessage().startsWith("[JGLOBUS-96]")) {
                throw new GlobusCredentialException(1, "expired00", e);
            }
            throw new GlobusCredentialException(3, "certVerifyError", e);
        }
    }

    public X509Certificate getIdentityCertificate() {
        try {
            return BouncyCastleUtil.getIdentityCertificate(this.certs);
        }
        catch (CertificateException e) {
            logger.debug("Error getting certificate identity", e);
            return null;
        }
    }

    public int getPathConstraint() {
        int pathLength = Integer.MAX_VALUE;
        try {
            int i = 0;
            while (i < this.certs.length) {
                int length = BouncyCastleUtil.getProxyPathConstraint(this.certs[i]);
                if (length == -1) {
                    length = Integer.MAX_VALUE;
                }
                if (length < pathLength) {
                    pathLength = length;
                }
                ++i;
            }
        }
        catch (IOException e) {
            logger.error("Error retrieving path length", e);
            pathLength = -1;
        }
        catch (CertificateEncodingException e) {
            logger.error("Error retrieving path length", e);
            pathLength = -1;
        }
        return pathLength;
    }

    public String getIdentity() {
        try {
            return BouncyCastleUtil.getIdentity(this.certs);
        }
        catch (CertificateException e) {
            logger.debug("Error getting certificate identity", e);
            return null;
        }
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certs;
    }

    public int getCertNum() {
        int i = this.certs.length - 1;
        while (i >= 0) {
            if (!this.certs[i].getSubjectDN().equals(this.certs[i].getIssuerDN())) {
                return i + 1;
            }
            --i;
        }
        return this.certs.length;
    }

    public int getStrength() {
        if (this.key == null) {
            return -1;
        }
        return ((RSAPrivateKey)this.key).getModulus().bitLength();
    }

    public String getSubject() {
        return this.certs[0].getSubjectDN().getName();
    }

    public String getIssuer() {
        return this.certs[0].getIssuerDN().getName();
    }

    public int getProxyType() {
        try {
            return BouncyCastleUtil.getCertificateType(this.certs[0]);
        }
        catch (CertificateException e) {
            logger.debug("Error getting certificate type", e);
            return -1;
        }
    }

    public long getTimeLeft() {
        Date earliestTime = null;
        int i = 0;
        while (i < this.certs.length) {
            Date time = this.certs[i].getNotAfter();
            if (earliestTime == null || time.before(earliestTime)) {
                earliestTime = time;
            }
            ++i;
        }
        long diff = (earliestTime.getTime() - System.currentTimeMillis()) / 1000L;
        return diff < 0L ? 0L : diff;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        BouncyCastleOpenSSLKey encodedKey = new BouncyCastleOpenSSLKey(this.key);
        byte[] encoded = encodedKey.getEncoded();
        oos.writeInt(encoded.length);
        oos.write(encoded);
        oos.writeInt(this.certs.length);
        try {
            int i = 0;
            while (i < this.certs.length) {
                encoded = this.certs[i].getEncoded();
                oos.writeInt(encoded.length);
                oos.write(encoded);
                ++i;
            }
        }
        catch (Exception e) {
            throw new ChainedIOException("", e);
        }
    }

    private static byte[] readData(ObjectInputStream ois) throws IOException {
        int len = ois.readInt();
        byte[] encoded = new byte[len];
        SSLUtil.readFully(ois, encoded, 0, len);
        return encoded;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            byte[] encoded = GlobusCredential.readData(ois);
            BouncyCastleOpenSSLKey encodedKey = new BouncyCastleOpenSSLKey("RSA", encoded);
            this.key = encodedKey.getPrivateKey();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ChainedIOException("", e);
        }
        int certs = ois.readInt();
        this.certs = new X509Certificate[certs];
        try {
            int i = 0;
            while (i < certs) {
                ByteArrayInputStream in = new ByteArrayInputStream(GlobusCredential.readData(ois));
                this.certs[i] = CertUtil.loadCertificate(in);
                ++i;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ChainedIOException("", e);
        }
    }

    public static synchronized GlobusCredential getDefaultCredential() throws GlobusCredentialException {
        if (defaultCred == null) {
            GlobusCredential.reloadDefaultCredential();
        } else if (!credentialSet) {
            if (credentialFile.lastModified() == credentialLastModified) {
                defaultCred.verify();
            } else {
                defaultCred = null;
                GlobusCredential.reloadDefaultCredential();
            }
        }
        return defaultCred;
    }

    private static void reloadDefaultCredential() throws GlobusCredentialException {
        String proxyLocation = CoGProperties.getDefault().getProxyFile();
        defaultCred = new GlobusCredential(proxyLocation);
        credentialFile = new File(proxyLocation);
        credentialLastModified = credentialFile.lastModified();
        defaultCred.verify();
    }

    public static synchronized void setDefaultCredential(GlobusCredential cred) {
        defaultCred = cred;
        credentialSet = cred != null;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("subject    : ").append(this.getSubject()).append(lineSep);
        buf.append("issuer     : ").append(this.getIssuer()).append(lineSep);
        buf.append("strength   : ").append(String.valueOf(this.getStrength()) + " bits").append(lineSep);
        buf.append("timeleft   : ").append(String.valueOf(this.getTimeLeft()) + " sec").append(lineSep);
        buf.append("proxy type : ").append(CertUtil.getProxyTypeAsString(this.getProxyType()));
        return buf.toString();
    }
}

