/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;

public class TransferState {
    private static Log logger = LogFactory.getLog(TransferState.class.getName());
    private int transferDone = 0;
    private int transferStarted = 0;
    private Exception transferException = null;

    public synchronized void transferStarted() {
        ++this.transferStarted;
        this.notifyAll();
    }

    public synchronized void transferDone() {
        ++this.transferDone;
        this.notifyAll();
    }

    public synchronized void transferError(Exception e) {
        logger.debug("intercepted exception", e);
        if (this.transferException == null) {
            this.transferException = e;
        } else if (this.transferException instanceof InterruptedException || this.transferException instanceof InterruptedIOException) {
            this.transferException = e;
        }
        this.notifyAll();
    }

    public synchronized boolean isDone() {
        return this.transferDone >= 2;
    }

    public synchronized void waitForEnd() throws ServerException, ClientException, IOException {
        try {
            while (!this.isDone()) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkError();
    }

    /*
     * Exception decompiling
     */
    public synchronized void waitForStart() throws ServerException, ClientException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized boolean hasError() {
        return this.transferException != null;
    }

    public Exception getError() {
        return this.transferException;
    }

    public void checkError() throws ServerException, ClientException, IOException {
        if (this.transferException == null) {
            return;
        }
        if (this.transferException instanceof ServerException) {
            throw (ServerException)this.transferException;
        }
        if (this.transferException instanceof IOException) {
            throw (IOException)this.transferException;
        }
        if (this.transferException instanceof InterruptedException) {
            throw new ClientException(7);
        }
    }
}

