/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

public class Command {
    public static final Command FEAT = new Command("FEAT");
    public static final Command ABOR = new Command("ABOR");
    public static final Command CDUP = new Command("CDUP");
    public static final Command PWD = new Command("PWD");
    public static final Command QUIT = new Command("QUIT");
    public static final Command PASV = new Command("PASV");
    public static final Command SPAS = new Command("SPAS");
    public static final Command EPSV = new Command("EPSV");
    private String name;
    private String parameters;

    public Command(String name, String parameters) throws IllegalArgumentException {
        this.initialize(name, parameters);
    }

    public Command(String name) throws IllegalArgumentException {
        this.initialize(name, null);
    }

    private void initialize(String name, String parameters) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (parameters != null && parameters.endsWith("\r\n")) {
            throw new IllegalArgumentException("parameters end with EOL");
        }
        this.name = name;
        this.parameters = parameters;
    }

    public static String toString(Command command) {
        return command.toString();
    }

    public String toString() {
        if (this.parameters == null) {
            return String.valueOf(this.name) + "\r\n";
        }
        return String.valueOf(this.name) + " " + this.parameters + "\r\n";
    }
}

