/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.dc.Task;

public class TaskThread
implements Runnable {
    static final int MAX_TASK_QUEUE = 100;
    protected static Log logger = LogFactory.getLog(TaskThread.class.getName());
    protected Buffer buffer = new Buffer(100);
    protected boolean stop;
    protected Thread thread;

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setName("Task" + this.thread.getName());
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void runTask(Task task) {
        this.start();
        try {
            this.buffer.put(task);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Task getNextTask() {
        try {
            return (Task)this.buffer.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void run() {
        this.stop = false;
        while (!this.stop) {
            Task task = this.getNextTask();
            if (task == null) break;
            Exception exception = null;
            try {
                logger.debug("executing task: " + task.toString());
                task.execute();
                logger.debug("finished task: " + task.toString());
            }
            catch (Exception e) {
                exception = e;
            }
            task.setComplete(exception);
        }
    }

    public synchronized void stop() {
        this.stop = true;
        this.buffer.release();
    }

    public void join() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class Buffer {
        protected Object[] buf;
        protected int in = 0;
        protected int out = 0;
        protected int count = 0;
        protected int size;

        public Buffer(int size) {
            this.size = size;
            this.buf = new Object[size];
        }

        public synchronized void put(Object o) throws InterruptedException {
            while (this.count == this.size) {
                this.wait();
                if (!TaskThread.this.stop) continue;
                return;
            }
            this.buf[this.in] = o;
            ++this.count;
            this.in = (this.in + 1) % this.size;
            this.notify();
        }

        public synchronized Object get() throws InterruptedException {
            while (this.count == 0) {
                this.wait();
                if (!TaskThread.this.stop) continue;
                return null;
            }
            Object o = this.buf[this.out];
            this.buf[this.out] = null;
            --this.count;
            this.out = (this.out + 1) % this.size;
            this.notify();
            return o;
        }

        public synchronized void release() {
            this.notify();
        }
    }
}

