/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;
import org.globus.util.CircularBuffer;

public class InputStreamDataSink
implements DataSink {
    protected CircularBuffer buffers = new CircularBuffer(5);
    private DataInputStream in = new DataInputStream();
    private boolean closed = false;

    @Override
    public void write(Buffer buffer) throws IOException {
        if (this.isClosed()) {
            throw new EOFException();
        }
        try {
            if (!this.buffers.put(buffer)) {
                throw new EOFException();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public void close() throws IOException {
        this.setClosed();
        this.buffers.closePut();
    }

    private synchronized void setClosed() {
        this.closed = true;
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    class DataInputStream
    extends InputStream {
        protected byte[] buff;
        protected int index;
        protected int length;

        DataInputStream() {
        }

        @Override
        public synchronized int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        @Override
        public synchronized int read(byte[] data, int off, int len) throws IOException {
            if (!this.ensureData()) {
                return -1;
            }
            int max = this.index + len > this.length ? this.length - this.index : len;
            System.arraycopy(this.buff, this.index, data, off, max);
            this.index += max;
            return max;
        }

        @Override
        public synchronized int read() throws IOException {
            if (!this.ensureData()) {
                return -1;
            }
            return this.buff[this.index++] & 0xFF;
        }

        @Override
        public void close() throws IOException {
            InputStreamDataSink.this.buffers.interruptBoth();
        }

        protected synchronized boolean ensureData() throws IOException {
            if (InputStreamDataSink.this.buffers.isGetInterrupted()) {
                return false;
            }
            if (this.length == this.index) {
                Buffer buf;
                block5: {
                    try {
                        buf = (Buffer)InputStreamDataSink.this.buffers.get();
                        if (buf != null) break block5;
                        return false;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
                this.index = 0;
                this.length = buf.getLength();
                this.buff = buf.getBuffer();
            }
            return true;
        }
    }
}

