/*
 * Decompiled with CFR 0.152.
 */
package org.globus.common;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;

public class ChainedGeneralSecurityException
extends GeneralSecurityException {
    private Throwable exception;

    public ChainedGeneralSecurityException() {
    }

    public ChainedGeneralSecurityException(String detail) {
        super(detail);
    }

    public ChainedGeneralSecurityException(String detail, Throwable ex) {
        super(detail);
        this.exception = ex;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.exception != null) {
            String superString = this.getLocalMessage();
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.print(superString);
                ps.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.exception.printStackTrace(ps);
            }
        } else {
            super.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.exception != null) {
            String superString = this.getLocalMessage();
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.print(superString);
                pw.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.exception.printStackTrace(pw);
            }
        } else {
            super.printStackTrace(pw);
        }
    }

    @Override
    public String getMessage() {
        String answer = super.getMessage();
        if (this.exception != null && this.exception != this) {
            String msg = this.exception.getMessage();
            if (msg == null) {
                msg = this.exception.getClass().getName();
            }
            answer = String.valueOf(answer) + " [Caused by: " + msg + "]";
        }
        return answer;
    }

    private String getLocalMessage() {
        String message = super.getMessage();
        return message == null ? this.getClass().getName() : message;
    }
}

