/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.gridftp;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.grid.BaseSimpleTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.gridftp.GridFTPStorage;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.globus.ftp.DataSourceStream;
import org.globus.ftp.GridFTPClient;

public class GridFtpImport
extends BaseSimpleTransfer
implements SimpleTransfer,
Callable<TaskStatus> {
    private final GridFTPStorage storage;
    private final String path;
    private final InputStream is;
    private final boolean closeInputStream;

    public GridFtpImport(GridFTPStorage _storage, String _path, InputStream _is, boolean _closeInputStream) throws HiLALocationSyntaxException {
        super(_storage.getLocation().getChildLocation("imports").getChildLocation(UUID.randomUUID().toString()));
        this.storage = _storage;
        this.path = _path;
        this.is = _is;
        this.closeInputStream = _closeInputStream;
        HiLA.getExecutor().submit(this);
    }

    @Override
    public void abort() throws HiLAException {
        throw new HiLANotImplementedException("abort() not implemented for GridFTP import.");
    }

    @Override
    public String getId() throws HiLAException {
        return this.getLocation().getName();
    }

    @Override
    public List<Resource> getChildren() throws HiLAException {
        return Collections.emptyList();
    }

    @Override
    public TaskStatus call() throws Exception {
        this.setCurrentState(TaskStatus.RUNNING);
        try {
            GridFTPClient client = this.storage.lockClient();
            client.setPassive();
            client.setLocalActive();
            DataSourceStream ds = new DataSourceStream(this.is);
            client.put(this.path, ds, null);
            if (this.closeInputStream) {
                this.is.close();
            }
            this.setCurrentState(TaskStatus.SUCCESSFUL);
        }
        catch (Exception e) {
            HiLAException he = new HiLAException("File import failed.", e);
            this.setCurrentState(TaskStatus.FAILED, he);
            throw he;
        }
        finally {
            this.storage.unlockClient();
        }
        return this.status();
    }
}

