/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.gridftp;

import eu.unicore.hila.Location;
import eu.unicore.hila.LocationPattern;
import eu.unicore.hila.Resource;
import eu.unicore.hila.ResourceTypeRegistry;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseStorage;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.gridftp.GridFtpProperties;
import eu.unicore.hila.gridftp.LocalCredentialHelper;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.globus.ftp.FileInfo;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.ietf.jgss.GSSException;

@ResourceType(locationStructure={"gsiftp://{hostname}:{port}/?", "gsiftp://{hostname}/?"})
public class GridFTPStorage
extends BaseStorage
implements Storage {
    private static final Logger log = Logger.getLogger(GridFTPStorage.class);
    private static final Cache storagesCache;
    final Lock clientLock = new ReentrantLock(true);
    private GridFTPClient client;
    private Map<String, String> locationVars;

    private GridFTPStorage(Location _location) throws HiLALocationSyntaxException, HiLAFactoryException {
        super(_location);
        try {
            this.clientLock.lock();
            LocationPattern lp = ResourceTypeRegistry.getInstance().determineLocationPattern(_location);
            this.locationVars = lp.fillTemplates(_location);
            this.createClient();
        }
        catch (ServerException e) {
            throw new HiLAFactoryException("Cannot connect to GridFTP server for " + this.location, e);
        }
        catch (IOException e) {
            throw new HiLAFactoryException("Cannot connect to GridFTP server for " + this.location, e);
        }
        catch (GSSException e) {
            throw new HiLAFactoryException("Unable to authenticate against GridFTP server.", e);
        }
        catch (HiLAException e) {
            throw new HiLAFactoryException("Unable to setup GridFTP storage.", e);
        }
        finally {
            this.clientLock.unlock();
        }
    }

    private void createClient() throws IOException, ServerException, GSSException, HiLAException {
        this.client = new GridFTPClient(this.locationVars.get("{hostname}"), this.locationVars.get("{port}") == null ? 2811 : Integer.parseInt(this.locationVars.get("{port}")));
        GridFtpProperties props = GridFtpProperties.getInstance();
        GlobusCredential cred = null;
        try {
            cred = new GlobusCredential((PrivateKey)props.getKeystore().getKey(props.getAlias(), props.getPassword().toCharArray()), new X509Certificate[]{(X509Certificate)props.getKeystore().getCertificate(props.getAlias())});
        }
        catch (Exception e) {
            log.warn("Exception using keystore configuration.", e);
        }
        if (cred != null) {
            GlobusGSSCredentialImpl gssCred = new GlobusGSSCredentialImpl(cred, 0);
            this.client.authenticate(gssCred);
        } else {
            this.client.authenticate(new LocalCredentialHelper().getDefaultCredential());
        }
        this.client.setProtectionBufferSize(16384);
        this.client.changeDir("/");
    }

    public static synchronized GridFTPStorage locate(Location _location, Object ... _extraInformation) throws HiLALocationSyntaxException, HiLAFactoryException {
        if (storagesCache.isKeyInCache(_location)) {
            Element storageElem = storagesCache.get(_location);
            return (GridFTPStorage)storageElem.getObjectValue();
        }
        GridFTPStorage gftp = new GridFTPStorage(_location);
        storagesCache.put(new Element(_location, gftp));
        return gftp;
    }

    public GridFTPClient lockClient() throws HiLAException {
        this.clientLock.lock();
        try {
            this.client.getCurrentDir();
        }
        catch (ServerException e) {
            try {
                this.createClient();
            }
            catch (Exception e1) {
                this.clientLock.unlock();
                throw new HiLAException("Unable to (re)create GridFTP client.", e1);
            }
        }
        catch (IOException e) {
            this.clientLock.unlock();
            throw new HiLAException("IO Exception in GridFTP client.", e);
        }
        return this.client;
    }

    public void unlockClient() {
        this.clientLock.unlock();
    }

    @Override
    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> files = new ArrayList<Resource>();
        try {
            this.lockClient();
            this.client.setPassive();
            this.client.setLocalActive();
            Vector fileList = this.client.list();
            for (Object object : fileList) {
                FileInfo file = (FileInfo)object;
                if (file.getName().equals("..") || file.getName().equals(".")) continue;
                Location fileLocation = this.location.getChildLocation(file.getName());
                files.add(fileLocation.locate(this, file));
            }
        }
        catch (ServerException e) {
            throw new HiLAException("Unable to list file(s) for " + this.location, e);
        }
        catch (ClientException e) {
            throw new HiLAException("Unable to list file(s) for " + this.location, e);
        }
        catch (IOException e) {
            throw new HiLAException("Unable to list file(s) for " + this.location, e);
        }
        finally {
            this.unlockClient();
        }
        return files;
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        manager.addCache(new Cache(GridFTPStorage.class.getName(), 500, true, true, 0L, 0L));
        storagesCache = manager.getCache(GridFTPStorage.class.getName());
    }
}

