/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.gridftp;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseFile;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.exceptions.HiLANotSupportedException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.ThirdPartyTransfer;
import eu.unicore.hila.gridftp.GridFTPStorage;
import eu.unicore.hila.gridftp.GridFtpExport;
import eu.unicore.hila.gridftp.GridFtpImport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.globus.ftp.FileInfo;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.MlsxEntry;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;

@ResourceType(locationStructure={"gsiftp://{hostname}:{port}/.+?", "gsiftp://{hostname}/.+?"})
public class GridFTPFile
extends BaseFile
implements File {
    private static final int UNIX_READ = 4;
    private static final int UNIX_WRITE = 2;
    private static final int UNIX_EXEC = 1;
    private static final Logger log = Logger.getLogger(GridFTPFile.class);
    private MlsxEntry mlsxEntry;
    private long mlsxEntryTimestamp = 0L;
    private GridFTPStorage storage;
    private static final Cache filesCache;

    GridFTPFile(Location _location, Object ... _extraInformation) throws HiLAException {
        super(_location);
        for (Object object : _extraInformation) {
            if (object instanceof FileInfo) {
                FileInfo fileInfo = (FileInfo)object;
                continue;
            }
            if (!(object instanceof GridFTPStorage)) continue;
            this.storage = (GridFTPStorage)object;
        }
        if (this.storage == null) {
            this.storage = (GridFTPStorage)GridFTPFile.findParentLocationOfType(Storage.class, this.location, Storage.class).locate(new Object[0]);
            if (this.storage == null) {
                throw new HiLAFactoryException("Cannot instantiate file " + this.location + " w/o storage.");
            }
        }
        this.path = this.storage.getLocation().relativePath(this.location);
    }

    public static synchronized Resource locate(Location _location, Object ... _extraInformation) throws HiLAException {
        Element cacheElem = filesCache.get(_location);
        if (cacheElem != null) {
            return (Resource)cacheElem.getObjectValue();
        }
        GridFTPFile file = new GridFTPFile(_location, _extraInformation);
        filesCache.put(new Element(_location, file));
        return file;
    }

    @Override
    public List<File> ls() throws HiLAException {
        if (!this.isDirectory()) {
            return Collections.singletonList(this);
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            GridFTPClient client = this.storage.lockClient();
            client.setPassive();
            client.setLocalActive();
            Vector rawFileList = client.list(this.path);
            for (Object fileInfoObj : rawFileList) {
                FileInfo fileInfo = (FileInfo)fileInfoObj;
                if (fileInfo.getName().equals("..") || fileInfo.getName().equals(".")) continue;
                Location fileLoc = this.location.getChildLocation(fileInfo.getName());
                File file = (File)fileLoc.locate(fileInfo, this.storage);
                files.add(file);
            }
        }
        catch (ServerException e) {
            throw new HiLAException("Unable to list file(s) for " + this.location, e);
        }
        catch (ClientException e) {
            throw new HiLAException("Unable to list file(s) for " + this.location, e);
        }
        catch (IOException e) {
            throw new HiLAException("Unable to list file(s) for " + this.location, e);
        }
        finally {
            this.storage.unlockClient();
        }
        return files;
    }

    @Override
    public boolean exists() throws HiLAException {
        try {
            GridFTPClient client = this.storage.lockClient();
            client.setPassive();
            client.setLocalActive();
            boolean bl = client.exists(this.path);
            return bl;
        }
        catch (Exception e) {
            throw new HiLAException("Unable to determine existence of file: " + this.location, e);
        }
        finally {
            this.storage.unlockClient();
        }
    }

    private synchronized void updateFileInfo() throws HiLAException {
        if (this.mlsxEntry != null && System.currentTimeMillis() < this.mlsxEntryTimestamp + 500L) {
            return;
        }
        String parentPath = this.storage.getLocation().relativePath(this.location.getParentLocation());
        if (log.isDebugEnabled()) {
            log.debug("parentPath == " + parentPath);
        }
        try {
            GridFTPClient client = this.storage.lockClient();
            this.mlsxEntry = client.mlst(this.path);
            this.mlsxEntryTimestamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new HiLAException("Unable to update file information.", e);
        }
        finally {
            this.storage.unlockClient();
        }
    }

    @Override
    public boolean isReadable() throws HiLAException {
        this.updateFileInfo();
        if (this.exists()) {
            int userMode = this.mlsxEntry.get("unix.mode").charAt(1) - 48;
            return (userMode & 4) > 0;
        }
        throw new HiLAException("File does not exist: " + this.location);
    }

    @Override
    public void setIsReadable(boolean _readable) throws HiLAException {
        throw new HiLANotSupportedException("GridFTP does not support setting permissions.");
    }

    @Override
    public boolean isWritable() throws HiLAException {
        this.updateFileInfo();
        if (this.exists()) {
            int userMode = this.mlsxEntry.get("unix.mode").charAt(1) - 48;
            return (userMode & 2) > 0;
        }
        throw new HiLAException("File does not exist: " + this.location);
    }

    @Override
    public void setIsWritable(boolean _writable) throws HiLAException {
        throw new HiLANotSupportedException("GridFTP does not support setting permissions.");
    }

    @Override
    public boolean isExecutable() throws HiLAException {
        this.updateFileInfo();
        if (this.exists()) {
            int userMode = this.mlsxEntry.get("unix.mode").charAt(1) - 48;
            return (userMode & 1) > 0;
        }
        throw new HiLAException("File does not exist: " + this.location);
    }

    @Override
    public void setIsExecutable(boolean _executable) throws HiLAException {
        throw new HiLANotSupportedException("GridFTP does not support setting permissions.");
    }

    @Override
    public boolean delete(boolean _recursive) throws HiLAException {
        try {
            GridFTPClient client = this.storage.lockClient();
            client.setPassive();
            client.setLocalActive();
            if (this.exists() && this.isDirectory() && _recursive) {
                client.deleteDir(this.path);
                boolean bl = true;
                return bl;
            }
            if (this.exists() && !this.isDirectory()) {
                client.deleteFile(this.path);
                boolean bl = true;
                return bl;
            }
            if (!this.exists()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            throw new HiLAException("Unable to delete " + this.location, e);
        }
        finally {
            this.storage.unlockClient();
        }
        return false;
    }

    @Override
    public boolean mkdir(boolean _createParents) throws HiLAException {
        try {
            GridFTPClient client = this.storage.lockClient();
            try {
                client.makeDir(this.path);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new HiLAException("Unable to create directory " + this.location, e);
            }
        }
        finally {
            this.storage.unlockClient();
        }
    }

    @Override
    public Storage getStorage() throws HiLAException {
        return this.storage;
    }

    @Override
    public SimpleTransfer importFromLocalFile(java.io.File localFile, boolean _overwrite, boolean _recursive) throws HiLAException {
        try {
            return this.importFromStream(new FileInputStream(localFile), _overwrite);
        }
        catch (FileNotFoundException e) {
            throw new HiLAException("File not found.", e);
        }
    }

    @Override
    public SimpleTransfer exportToLocalFile(java.io.File localFile, boolean _overwrite, boolean _recursive) throws HiLAException {
        java.io.File actualFile = localFile;
        if (localFile.exists() && localFile.isDirectory()) {
            actualFile = new java.io.File(localFile, this.getName());
        }
        if (!actualFile.exists() || _overwrite) {
            try {
                FileOutputStream fos = new FileOutputStream(actualFile);
                return this.exportToStream(fos, true);
            }
            catch (FileNotFoundException e) {
                throw new HiLAException("File not found.", e);
            }
        }
        throw new HiLAException("Local file exists, but must not be overwritten.");
    }

    @Override
    public SimpleTransfer exportToStream(OutputStream _os) throws HiLAException {
        return this.exportToStream(_os, false);
    }

    private SimpleTransfer exportToStream(OutputStream _os, boolean _closeOutputStream) throws HiLAException {
        return new GridFtpExport(this.storage, this.path, _os, _closeOutputStream);
    }

    @Override
    public SimpleTransfer importFromStream(InputStream _is, boolean _overwrite) throws HiLAException {
        if (!this.exists() || _overwrite) {
            return new GridFtpImport(this.storage, this.path, _is, false);
        }
        throw new HiLAException("File exists, but cannot be overwritten.");
    }

    @Override
    public ThirdPartyTransfer transfer(File _other, boolean _overwrite, boolean _recursive) throws HiLAException {
        throw new HiLANotImplementedException("");
    }

    @Override
    public long size() throws HiLAException {
        this.updateFileInfo();
        return Long.parseLong(this.mlsxEntry.get("size"));
    }

    @Override
    public Date lastModified() throws HiLAException {
        GridFTPClient client = this.storage.lockClient();
        try {
            client.setPassive();
            client.setLocalActive();
            Date date = client.lastModified(this.path);
            return date;
        }
        catch (Exception e) {
            throw new HiLAException("Unable to determine last modified date for " + this.location, e);
        }
        finally {
            this.storage.unlockClient();
        }
    }

    @Override
    public void copyTo(File _other, boolean _overwrite, boolean _recursive) throws HiLAException {
        throw new HiLANotSupportedException("GridFTP does not support local file copies.");
    }

    @Override
    public void moveTo(File _other, boolean _overwrite) throws HiLAException {
        File realFile = _other;
        if (_other.exists() && _other.isDirectory()) {
            realFile = (File)_other.getChild(this.getName());
        }
        if (realFile.exists() || _overwrite) {
            try {
                GridFTPClient client = this.storage.lockClient();
                client.setPassive();
                client.setLocalActive();
                client.rename(this.path, ((GridFTPFile)realFile).path);
            }
            catch (Exception e) {
                throw new HiLAException("Unable to rename file.", e);
            }
            finally {
                this.storage.unlockClient();
            }
        } else {
            throw new HiLAException("moveTo(): target exists");
        }
    }

    @Override
    public boolean isDirectory() throws HiLAException {
        if (this.mlsxEntry != null) {
            return this.mlsxEntry.get("type").equals("dir");
        }
        try {
            GridFTPClient client = this.storage.lockClient();
            try {
                MlsxEntry mlsxEntry = client.mlst(this.path);
                boolean bl = mlsxEntry.get("type").equals("dir");
                return bl;
            }
            catch (Exception e) {
                throw new HiLAException("Unable to determine whether this is a directory.", e);
            }
        }
        finally {
            this.storage.unlockClient();
        }
    }

    static {
        CacheManager cm = CacheManager.getInstance();
        cm.addCache(new Cache(GridFTPFile.class.getName(), 500, true, true, 0L, 0L));
        filesCache = cm.getCache(GridFTPFile.class.getName());
    }
}

