/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingInHandler;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.ClientReceiveHandler;
import org.codehaus.xfire.client.Correlator;
import org.codehaus.xfire.client.Invocation;
import org.codehaus.xfire.handler.AbstractHandler;

public class CorrelatorHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(Client.class);
    private Collection calls;
    private Correlator correlator;

    public CorrelatorHandler(Collection calls) {
        this.setPhase("pre-dispatch");
        this.after(AddressingInHandler.class.getName());
        this.calls = calls;
    }

    public void invoke(MessageContext context) throws Exception {
        log.debug("Correlating context with ID " + context.getId());
        Invocation invocation = this.correlator.correlate(context, this.calls);
        if (invocation == null) {
            log.info("No correlated invocation was found.");
            return;
        }
        if (context != invocation.getContext()) {
            context.getExchange().setOperation(invocation.getContext().getExchange().getOperation());
            context.getExchange().setOutMessage(invocation.getContext().getExchange().getOutMessage());
        }
        if (invocation != null) {
            log.debug("Found correlated context with ID " + context.getId());
            context.getInPipeline().addHandler(new ClientReceiveHandler(invocation));
        }
    }

    public Correlator getCorrelator() {
        return this.correlator;
    }

    public void setCorrelator(Correlator correlator) {
        this.correlator = correlator;
    }
}

