/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.util.Loader;

public class Merlin
extends CryptoBase {
    public static final String OLD_KEYSTORE_FILE = "org.apache.ws.security.crypto.merlin.file";
    public static final String CRYPTO_KEYSTORE_PROVIDER = "org.apache.ws.security.crypto.merlin.keystore.provider";
    public static final String CRYPTO_CERT_PROVIDER = "org.apache.ws.security.crypto.merlin.cert.provider";
    public static final String KEYSTORE_FILE = "org.apache.ws.security.crypto.merlin.keystore.file";
    public static final String KEYSTORE_PASSWORD = "org.apache.ws.security.crypto.merlin.keystore.password";
    public static final String KEYSTORE_TYPE = "org.apache.ws.security.crypto.merlin.keystore.type";
    public static final String KEYSTORE_ALIAS = "org.apache.ws.security.crypto.merlin.keystore.alias";
    public static final String KEYSTORE_PRIVATE_PASSWORD = "org.apache.ws.security.crypto.merlin.keystore.private.password";
    public static final String LOAD_CA_CERTS = "org.apache.ws.security.crypto.merlin.load.cacerts";
    public static final String TRUSTSTORE_FILE = "org.apache.ws.security.crypto.merlin.truststore.file";
    public static final String TRUSTSTORE_PASSWORD = "org.apache.ws.security.crypto.merlin.truststore.password";
    public static final String TRUSTSTORE_TYPE = "org.apache.ws.security.crypto.merlin.truststore.type";
    public static final String X509_CRL_FILE = "org.apache.ws.security.crypto.merlin.x509crl.file";
    private static final Log log = LogFactory.getLog(Merlin.class);
    private static final boolean doDebug = log.isDebugEnabled();
    protected static CertificateFactory certFact;
    protected Properties properties = null;
    protected KeyStore keystore = null;
    protected KeyStore truststore = null;
    protected CertStore crlCertStore = null;
    protected boolean loadCACerts = false;
    protected boolean privatePasswordSet = false;

    public Merlin() {
    }

    public Merlin(Properties properties) throws CredentialException, IOException {
        this(properties, Loader.getClassLoader(Merlin.class));
    }

    public Merlin(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        this.loadProperties(properties, loader);
    }

    public void loadProperties(Properties properties) throws CredentialException, IOException {
        this.loadProperties(properties, Loader.getClassLoader(Merlin.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void loadProperties(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        if (properties == null) {
            return;
        }
        this.properties = properties;
        provider = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.provider");
        if (provider != null) {
            provider = provider.trim();
        }
        if ((certProvider = properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider")) != null) {
            this.setCryptoProvider(certProvider);
        }
        if ((alias = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.alias")) != null) {
            this.defaultAlias = alias = alias.trim();
        }
        if ((keyStoreLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.file")) == null) {
            keyStoreLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.file");
        }
        if (keyStoreLocation != null) {
            keyStoreLocation = keyStoreLocation.trim();
            is = Merlin.loadInputStream(loader, keyStoreLocation);
            try {
                passwd = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password", "security");
                if (passwd != null) {
                    passwd = passwd.trim();
                }
                if ((type = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type", KeyStore.getDefaultType())) != null) {
                    type = type.trim();
                }
                this.keystore = this.load(is, passwd, provider, type);
                if (Merlin.doDebug) {
                    Merlin.log.debug("The KeyStore " + keyStoreLocation + " of type " + type + " has been loaded");
                }
                if ((privatePasswd = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.private.password")) == null) ** GOTO lbl34
                this.privatePasswordSet = true;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else if (Merlin.doDebug) {
            Merlin.log.debug("The KeyStore is not loaded as KEYSTORE_FILE is null");
        }
lbl34:
        // 5 sources

        if ((trustStoreLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.file")) != null) {
            trustStoreLocation = trustStoreLocation.trim();
            is = Merlin.loadInputStream(loader, trustStoreLocation);
            try {
                passwd = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.password", "changeit");
                if (passwd != null) {
                    passwd = passwd.trim();
                }
                if ((type = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.type", KeyStore.getDefaultType())) != null) {
                    type = type.trim();
                }
                this.truststore = this.load(is, passwd, provider, type);
                if (Merlin.doDebug) {
                    Merlin.log.debug("The TrustStore " + trustStoreLocation + " of type " + type + " has been loaded");
                }
                this.loadCACerts = false;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        loadCacerts = properties.getProperty("org.apache.ws.security.crypto.merlin.load.cacerts", "false");
        if (loadCacerts != null) {
            loadCacerts = loadCacerts.trim();
        }
        if (Boolean.valueOf(loadCacerts).booleanValue()) {
            cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            if (cacertsPath != null) {
                cacertsPath = cacertsPath.trim();
            }
            is = new FileInputStream(cacertsPath);
            try {
                cacertsPasswd = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.password", "changeit");
                if (cacertsPasswd != null) {
                    cacertsPasswd = cacertsPasswd.trim();
                }
                this.truststore = this.load(is, cacertsPasswd, null, KeyStore.getDefaultType());
                if (Merlin.doDebug) {
                    Merlin.log.debug("CA certs have been loaded");
                }
                this.loadCACerts = true;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if ((crlLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.x509crl.file")) != null) {
            crlLocation = crlLocation.trim();
            is = Merlin.loadInputStream(loader, crlLocation);
            try {
                cf = this.getCertificateFactory();
                crl = (X509CRL)cf.generateCRL(is);
                this.crlCertStore = provider == null || provider.length() == 0 ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl))) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Collections.singletonList(crl)), provider);
                if (Merlin.doDebug) {
                    Merlin.log.debug("The CRL " + crlLocation + " has been loaded");
                }
            }
            catch (Exception e) {
                if (Merlin.doDebug) {
                    Merlin.log.debug(e.getMessage(), e);
                }
                throw new CredentialException(3, "ioError00", e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    public static InputStream loadInputStream(ClassLoader loader, String location) throws CredentialException, IOException {
        InputStream is = null;
        if (location != null) {
            URL url = Loader.getResource(loader, location);
            if (url != null) {
                is = url.openStream();
            }
            if (is == null) {
                try {
                    is = new FileInputStream(location);
                }
                catch (Exception e) {
                    if (doDebug) {
                        log.debug(e.getMessage(), e);
                    }
                    throw new CredentialException(3, "proxyNotFound", new Object[]{location}, e);
                }
            }
        }
        return is;
    }

    public KeyStore load(InputStream input, String storepass, String provider, String type) throws CredentialException {
        KeyStore ks = null;
        try {
            ks = provider == null || provider.length() == 0 ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            ks.load(input, storepass == null || storepass.length() == 0 ? new char[]{} : storepass.toCharArray());
        }
        catch (IOException e) {
            if (doDebug) {
                log.debug(e.getMessage(), e);
            }
            throw new CredentialException(3, "ioError00", e);
        }
        catch (GeneralSecurityException e) {
            if (doDebug) {
                log.debug(e.getMessage(), e);
            }
            throw new CredentialException(4, "secError00", e);
        }
        catch (Exception e) {
            if (doDebug) {
                log.debug(e.getMessage(), e);
            }
            throw new CredentialException(-1, "error00", e);
        }
        return ks;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keystore = keyStore;
    }

    public KeyStore getTrustStore() {
        return this.truststore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.truststore = trustStore;
    }

    public void setCRLCertStore(CertStore crlCertStore) {
        this.crlCertStore = crlCertStore;
    }

    public CertStore getCRLCertStore() {
        return this.crlCertStore;
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        String provider = this.getCryptoProvider();
        String keyStoreProvider = null;
        if (this.keystore != null) {
            keyStoreProvider = this.keystore.getProvider().getName();
        }
        CertificateFactory factory = null;
        if (provider != null) {
            factory = (CertificateFactory)this.certFactMap.get(provider);
        } else if (keyStoreProvider != null) {
            factory = (CertificateFactory)this.certFactMap.get(this.mapKeystoreProviderToCertProvider(keyStoreProvider));
            if (factory == null) {
                factory = (CertificateFactory)this.certFactMap.get(keyStoreProvider);
            }
        } else {
            factory = (CertificateFactory)this.certFactMap.get("DEFAULT");
        }
        if (factory == null) {
            try {
                if (provider == null || provider.length() == 0) {
                    if (keyStoreProvider != null && keyStoreProvider.length() != 0) {
                        try {
                            factory = CertificateFactory.getInstance("X.509", this.mapKeystoreProviderToCertProvider(keyStoreProvider));
                            this.certFactMap.put(keyStoreProvider, factory);
                            this.certFactMap.put(this.mapKeystoreProviderToCertProvider(keyStoreProvider), factory);
                        }
                        catch (Exception ex) {
                            log.debug(ex);
                        }
                    }
                    if (factory == null) {
                        factory = CertificateFactory.getInstance("X.509");
                        this.certFactMap.put("DEFAULT", factory);
                    }
                } else {
                    factory = CertificateFactory.getInstance("X.509", provider);
                    this.certFactMap.put(provider, factory);
                }
                this.certFactMap.put(factory.getProvider().getName(), factory);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType", null, e);
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider", null, e);
            }
        }
        return factory;
    }

    private String mapKeystoreProviderToCertProvider(String s) {
        if ("SunJSSE".equals(s)) {
            return "SUN";
        }
        return s;
    }

    public String getDefaultX509Identifier() throws WSSecurityException {
        if (this.defaultAlias != null) {
            return this.defaultAlias;
        }
        if (this.keystore != null) {
            try {
                Enumeration<String> as = this.keystore.aliases();
                if (as.hasMoreElements()) {
                    String alias = as.nextElement();
                    if (!as.hasMoreElements()) {
                        this.defaultAlias = alias;
                        return alias;
                    }
                }
            }
            catch (KeyStoreException ex) {
                throw new WSSecurityException(0, "keystore", null, ex);
            }
        }
        return null;
    }

    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        if (cryptoType == null) {
            return null;
        }
        CryptoType.TYPE type = cryptoType.getType();
        X509Certificate[] certs = null;
        switch (type) {
            case ISSUER_SERIAL: {
                certs = this.getX509Certificates(cryptoType.getIssuer(), cryptoType.getSerial());
                break;
            }
            case THUMBPRINT_SHA1: {
                certs = this.getX509Certificates(cryptoType.getBytes());
                break;
            }
            case SKI_BYTES: {
                certs = this.getX509CertificatesSKI(cryptoType.getBytes());
                break;
            }
            case SUBJECT_DN: {
                certs = this.getX509CertificatesSubjectDN(cryptoType.getSubjectDN());
                break;
            }
            case ALIAS: {
                certs = this.getX509Certificates(cryptoType.getAlias());
            }
        }
        return certs;
    }

    public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
        String identifier = null;
        if (this.keystore != null) {
            identifier = this.getIdentifier(cert, this.keystore);
        }
        if (identifier == null && this.truststore != null) {
            identifier = this.getIdentifier(cert, this.truststore);
        }
        return identifier;
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        if (this.keystore == null) {
            throw new WSSecurityException("The keystore is null");
        }
        if (callbackHandler == null) {
            throw new WSSecurityException("The CallbackHandler is null");
        }
        String identifier = this.getIdentifier(certificate, this.keystore);
        try {
            Key keyTmp;
            if (identifier == null || !this.keystore.isKeyEntry(identifier)) {
                String msg = "Cannot find key for alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                log.error(msg + logMsg);
                throw new WSSecurityException(msg);
            }
            String password = this.getPassword(identifier, callbackHandler);
            if (password == null && this.privatePasswordSet && (password = this.properties.getProperty(KEYSTORE_PRIVATE_PASSWORD)) != null) {
                password = password.trim();
            }
            if (!((keyTmp = this.keystore.getKey(identifier, password == null ? new char[]{} : password.toCharArray())) instanceof PrivateKey)) {
                String msg = "Key is not a private key, alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                log.error(msg + logMsg);
                throw new WSSecurityException(msg);
            }
            return (PrivateKey)keyTmp;
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, ex);
        }
    }

    public PrivateKey getPrivateKey(String identifier, String password) throws WSSecurityException {
        if (this.keystore == null) {
            throw new WSSecurityException("The keystore is null");
        }
        try {
            Key keyTmp;
            if (identifier == null || !this.keystore.isKeyEntry(identifier)) {
                String msg = "Cannot find key for alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                log.error(msg + logMsg);
                throw new WSSecurityException(msg);
            }
            if (password == null && this.privatePasswordSet && (password = this.properties.getProperty(KEYSTORE_PRIVATE_PASSWORD)) != null) {
                password = password.trim();
            }
            if (!((keyTmp = this.keystore.getKey(identifier, password == null ? new char[]{} : password.toCharArray())) instanceof PrivateKey)) {
                String msg = "Key is not a private key, alias: [" + identifier + "]";
                String logMsg = Merlin.createKeyStoreErrorMessage(this.keystore);
                log.error(msg + logMsg);
                throw new WSSecurityException(msg);
            }
            return (PrivateKey)keyTmp;
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(0, "noPrivateKey", new Object[]{ex.getMessage()}, ex);
        }
    }

    @Deprecated
    public boolean verifyTrust(X509Certificate[] certs) throws WSSecurityException {
        return this.verifyTrust(certs, false);
    }

    public boolean verifyTrust(X509Certificate[] certs, boolean enableRevocation) throws WSSecurityException {
        try {
            TrustAnchor anchor;
            X509Certificate cert;
            String alias;
            List<X509Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
            if (this.truststore != null) {
                Enumeration<String> truststoreAliases = this.truststore.aliases();
                while (truststoreAliases.hasMoreElements()) {
                    alias = truststoreAliases.nextElement();
                    cert = (X509Certificate)this.truststore.getCertificate(alias);
                    if (cert == null) continue;
                    anchor = new TrustAnchor(cert, cert.getExtensionValue("2.5.29.30"));
                    set.add(anchor);
                }
            }
            if (this.keystore != null && (this.truststore == null || this.loadCACerts)) {
                Enumeration<String> aliases = this.keystore.aliases();
                while (aliases.hasMoreElements()) {
                    alias = aliases.nextElement();
                    cert = (X509Certificate)this.keystore.getCertificate(alias);
                    if (cert == null) continue;
                    anchor = new TrustAnchor(cert, cert.getExtensionValue("2.5.29.30"));
                    set.add(anchor);
                }
            }
            PKIXParameters param = new PKIXParameters(set);
            param.setRevocationEnabled(enableRevocation);
            if (enableRevocation && this.crlCertStore != null) {
                param.addCertStore(this.crlCertStore);
            }
            String provider = this.getCryptoProvider();
            CertPathValidator validator = null;
            validator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            validator.validate(path, param);
            return true;
        }
        catch (NoSuchProviderException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (CertPathValidatorException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (NullPointerException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
    }

    public boolean verifyTrust(PublicKey publicKey) throws WSSecurityException {
        if (publicKey == null) {
            return false;
        }
        boolean trust = this.findPublicKeyInKeyStore(publicKey, this.keystore);
        if (trust) {
            return true;
        }
        trust = this.findPublicKeyInKeyStore(publicKey, this.truststore);
        return trust;
    }

    private X509Certificate[] getX509Certificates(String issuer, BigInteger serialNumber) throws WSSecurityException {
        Object issuerName = null;
        try {
            X500Principal issuerRDN = new X500Principal(issuer);
            issuerName = this.createBCX509Name(issuerRDN.getName());
        }
        catch (IllegalArgumentException ex) {
            issuerName = this.createBCX509Name(issuer);
        }
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(issuerName, serialNumber, this.keystore);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(issuerName, serialNumber, this.truststore);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private Certificate[] getCertificates(Object issuerRDN, BigInteger serialNumber, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                Object certName;
                X509Certificate x509cert;
                String alias = e.nextElement();
                Certificate cert = null;
                Certificate[] certs = store.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = store.getCertificate(alias);
                    if (cert == null) continue;
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || (x509cert = (X509Certificate)cert).getSerialNumber().compareTo(serialNumber) != 0 || !(certName = this.createBCX509Name(x509cert.getIssuerX500Principal().getName())).equals(issuerRDN)) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return new Certificate[0];
    }

    private X509Certificate[] getX509Certificates(byte[] thumbprint) throws WSSecurityException {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(0, "noSHA1availabe", null, e);
        }
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(thumbprint, this.keystore, sha);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(thumbprint, this.truststore, sha);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private Certificate[] getCertificates(byte[] thumbprint, KeyStore store, MessageDigest sha) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate cert = null;
                Certificate[] certs = store.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = store.getCertificate(alias);
                    if (cert == null) continue;
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509cert = (X509Certificate)cert;
                try {
                    sha.update(x509cert.getEncoded());
                }
                catch (CertificateEncodingException ex) {
                    throw new WSSecurityException(7, "encodeError", null, ex);
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumbprint)) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return new Certificate[0];
    }

    private X509Certificate[] getX509CertificatesSKI(byte[] skiBytes) throws WSSecurityException {
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(skiBytes, this.keystore);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(skiBytes, this.truststore);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private Certificate[] getCertificates(byte[] skiBytes, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                X509Certificate x509cert;
                byte[] data;
                String alias = e.nextElement();
                Certificate cert = null;
                Certificate[] certs = store.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = store.getCertificate(alias);
                    if (cert == null) continue;
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || (data = this.getSKIBytesFromCert(x509cert = (X509Certificate)cert)).length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return new Certificate[0];
    }

    private X509Certificate[] getX509CertificatesSubjectDN(String subjectDN) throws WSSecurityException {
        Object subject;
        try {
            X500Principal subjectRDN = new X500Principal(subjectDN);
            subject = this.createBCX509Name(subjectRDN.getName());
        }
        catch (IllegalArgumentException ex) {
            subject = this.createBCX509Name(subjectDN);
        }
        Certificate[] certs = null;
        if (this.keystore != null) {
            certs = this.getCertificates(subject, this.keystore);
        }
        if ((certs == null || certs.length == 0) && this.truststore != null) {
            certs = this.getCertificates(subject, this.truststore);
        }
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private X509Certificate[] getX509Certificates(String identifier) throws WSSecurityException {
        Certificate[] certs = null;
        try {
            Certificate cert;
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(identifier)) == null || certs.length == 0) && (cert = this.keystore.getCertificate(identifier)) != null) {
                certs = new Certificate[]{cert};
            }
            if (certs == null && this.truststore != null && (certs = this.truststore.getCertificateChain(identifier)) == null && (cert = this.truststore.getCertificate(identifier)) != null) {
                certs = new Certificate[]{cert};
            }
            if (certs == null) {
                return null;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    private boolean findPublicKeyInKeyStore(PublicKey publicKey, KeyStore keyStoreToSearch) {
        try {
            Enumeration<String> e = keyStoreToSearch.aliases();
            while (e.hasMoreElements()) {
                X509Certificate x509cert;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = keyStoreToSearch.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keyStoreToSearch.getCertificate(alias);
                    if (cert == null) {
                        continue;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || !publicKey.equals((x509cert = (X509Certificate)cert).getPublicKey())) continue;
                return true;
            }
        }
        catch (KeyStoreException e) {
            return false;
        }
        return false;
    }

    private Certificate[] getCertificates(Object subjectRDN, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                X500Principal foundRDN;
                Object certName;
                String alias = e.nextElement();
                Certificate cert = null;
                Certificate[] certs = store.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = store.getCertificate(alias);
                    if (cert == null) continue;
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || !subjectRDN.equals(certName = this.createBCX509Name((foundRDN = ((X509Certificate)cert).getSubjectX500Principal()).getName()))) continue;
                return certs;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return new Certificate[0];
    }

    private static String createKeyStoreErrorMessage(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        StringBuilder sb = new StringBuilder(keystore.size() * 7);
        boolean firstAlias = true;
        while (aliases.hasMoreElements()) {
            if (!firstAlias) {
                sb.append(", ");
            }
            sb.append(aliases.nextElement());
            firstAlias = false;
        }
        String msg = " in keystore of type [" + keystore.getType() + "] from provider [" + keystore.getProvider() + "] with size [" + keystore.size() + "] and aliases: {" + sb.toString() + "}";
        return msg;
    }

    private String getIdentifier(X509Certificate cert, KeyStore store) throws WSSecurityException {
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                Certificate retrievedCert = null;
                if (certs == null || certs.length == 0) {
                    retrievedCert = store.getCertificate(alias);
                    if (retrievedCert == null) {
                        continue;
                    }
                } else {
                    retrievedCert = certs[0];
                }
                if (!(retrievedCert instanceof X509Certificate) || retrievedCert == null || !retrievedCert.equals(cert)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return null;
    }

    private String getPassword(String identifier, CallbackHandler cb) throws WSSecurityException {
        WSPasswordCallback pwCb = new WSPasswordCallback(identifier, 1);
        try {
            Callback[] callbacks = new Callback[]{pwCb};
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{identifier}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{identifier}, e);
        }
        return pwCb.getPassword();
    }
}

