/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.jetty;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.log.AbstractLogger;

public class JettyLogger
extends AbstractLogger
implements org.eclipse.jetty.util.log.Logger {
    private final Logger log;
    private Level configuredLevel;

    public JettyLogger() {
        this(null);
    }

    public JettyLogger(String name) {
        if (name == null) {
            name = this.getDefaultLog4jLoggerName();
        }
        this.log = Logger.getLogger(name);
        this.configuredLevel = this.log.getLevel();
    }

    protected String getDefaultLog4jLoggerName() {
        return "unicore.httpserver." + JettyLogger.class.getSimpleName();
    }

    @Override
    public String getName() {
        return this.log.getName();
    }

    @Override
    public void warn(String msg, Object ... args) {
        this.log.warn(this.format(msg, args));
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        this.log.warn(msg, thrown);
    }

    @Override
    public void info(String msg, Object ... args) {
        this.log.info(this.format(msg, args));
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Throwable thrown) {
        this.log.info(msg, thrown);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this.log.getLevel();
            this.log.setLevel(Level.DEBUG);
        } else {
            this.log.setLevel(this.configuredLevel);
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        this.log.debug(this.format(msg, args));
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        this.log.debug(msg, thrown);
    }

    @Override
    protected org.eclipse.jetty.util.log.Logger newLogger(String fullname) {
        return new JettyLogger(fullname);
    }

    @Override
    public void ignore(Throwable ignored) {
    }

    private String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }
}

