/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.unicore.util.Log;
import eu.unicore.util.httpclient.AuthSSLProtocolSocketFactory;
import eu.unicore.util.httpclient.CustomHostConfiguration;
import eu.unicore.util.httpclient.HttpHostFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.RedirectingHttpClient;
import eu.unicore.util.httpclient.RetryHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static final Logger logger = Log.getLogger("unicore.client", HttpUtils.class);
    public static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; XFire Client +http://xfire.codehaus.org)";
    public static final String CONNECTION_CLOSE = "http.connection-close";
    public static final String HTTP_MAX_REDIRECTS = "http.maxRedirects";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxy.user";
    public static final String HTTP_PROXY_PASS = "http.proxy.password";
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 6;
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private static final int DEFAULT_SO_TIMEOUT = 20000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    public static final String MAX_HOST_CONNECTIONS = "http.connection-manager.max-per-host";
    public static final String MAX_TOTAL_CONNECTIONS = "http.connection-manager.max-total";
    public static final String SO_TIMEOUT = "http.socket.timeout";
    public static final String CONNECT_TIMEOUT = "http.connection.timeout";

    private HttpUtils() {
    }

    public static synchronized HttpClient createClient(String uri, IClientConfiguration security) {
        HttpClient client = HttpUtils.createClient(security.getExtraSettings());
        if (security.isSslEnabled()) {
            HttpUtils.configureSSL(client, security);
        }
        HttpUtils.configureProxy(client, uri, security.getExtraSettings());
        return client;
    }

    public static synchronized HttpClient createClient(Properties properties) {
        boolean connClose = Boolean.parseBoolean(properties.getProperty(CONNECTION_CLOSE));
        int maxRedirects = HttpUtils.getIntValue(HTTP_MAX_REDIRECTS, properties, 3);
        RedirectingHttpClient client = new RedirectingHttpClient(connClose, maxRedirects);
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams conParams = new HttpConnectionManagerParams();
        manager.setParams(conParams);
        int maxConnPerHost = HttpUtils.getIntValue(MAX_HOST_CONNECTIONS, properties, 6);
        conParams.setDefaultMaxConnectionsPerHost(maxConnPerHost);
        int maxTotalConn = HttpUtils.getIntValue(MAX_TOTAL_CONNECTIONS, properties, 20);
        conParams.setMaxTotalConnections(maxTotalConn);
        client.setHttpConnectionManager(manager);
        int socketTimeout = HttpUtils.getIntValue(SO_TIMEOUT, properties, 20000);
        int connectTimeout = HttpUtils.getIntValue(CONNECT_TIMEOUT, properties, 15000);
        HttpUtils.setConnectionTimeout(client, socketTimeout, connectTimeout);
        HttpClientParams params = client.getParams();
        params.setParameter("http.useragent", USER_AGENT);
        params.setParameter("http.method.retry-handler", new RetryHandler());
        params.setVersion(HttpVersion.HTTP_1_1);
        return client;
    }

    public static void configureSSL(HttpClient client, IClientConfiguration security) {
        client.setHostConfiguration(HttpUtils.getHostConfiguration(security));
    }

    public static void configureProxy(HttpClient client, String uri, Properties properties) {
        if (HttpUtils.isNonProxyHost(uri, properties)) {
            return;
        }
        String proxyHost = properties.getProperty(HTTP_PROXY_HOST);
        if (proxyHost == null) {
            proxyHost = System.getProperty(HTTP_PROXY_HOST);
        }
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            String portS = properties.getProperty(HTTP_PROXY_PORT);
            if (portS == null) {
                portS = System.getProperty(HTTP_PROXY_PORT);
            }
            int port = 80;
            if (portS != null) {
                port = Integer.parseInt(portS);
            }
            client.getHostConfiguration().setProxy(proxyHost, port);
            String proxyUser = properties.getProperty(HTTP_PROXY_USER);
            String proxyPass = properties.getProperty(HTTP_PROXY_PASS);
            if (proxyUser != null && proxyPass != null) {
                client.getState().setProxyCredentials(AuthScope.ANY, HttpUtils.getCredentials(client, proxyUser, proxyPass));
            }
        }
    }

    private static HostConfiguration getHostConfiguration(IClientConfiguration sec) {
        AuthSSLProtocolSocketFactory protocolFact = new AuthSSLProtocolSocketFactory(sec);
        Protocol p = new Protocol(new String(HttpsURL.DEFAULT_SCHEME), (ProtocolSocketFactory)protocolFact, 443);
        HttpHostFactory fact = new HttpHostFactory(null, p);
        CustomHostConfiguration c = new CustomHostConfiguration(fact);
        return c;
    }

    private static boolean isNonProxyHost(String uri, Properties properties) {
        String nonProxyHosts = properties.getProperty(HTTP_NON_PROXY_HOSTS);
        if (nonProxyHosts == null) {
            return false;
        }
        try {
            String[] npHosts;
            URI u = new URI(uri);
            String host = u.getHost();
            for (String npHost : npHosts = nonProxyHosts.split(" ")) {
                if (!host.contains(npHost)) continue;
                return true;
            }
        }
        catch (URISyntaxException e) {
            logger.error("Can't resolve URI from " + uri, e);
        }
        return false;
    }

    private static Credentials getCredentials(HttpClient client, String username, String password) {
        client.getParams().setAuthenticationPreemptive(true);
        int domainIndex = username.indexOf(92);
        if (domainIndex > 0 && username.length() > domainIndex + 1) {
            return new NTCredentials(username.substring(0, domainIndex), password, "localhost", username.substring(domainIndex + 1));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    private static int getIntValue(String key, Properties properties, int defaultValue) {
        int result = defaultValue;
        String str = properties.getProperty(key);
        if (str != null) {
            result = Integer.parseInt(str);
        }
        return result;
    }

    public static void setConnectionTimeout(HttpClient client, int socketTimeout, int connectTimeout) {
        client.getParams().setSoTimeout(socketTimeout);
        client.getParams().setConnectionManagerTimeout(connectTimeout);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(connectTimeout);
    }
}

