/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.DPCServer;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.jparss.PSocket;
import eu.unicore.uftp.server.FileAccess;
import eu.unicore.uftp.server.ServerThread;
import eu.unicore.uftp.server.UFTPTransferRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import org.apache.log4j.Logger;

public class UFTPWorker
extends Thread {
    private static final Logger logger = Logger.getLogger(UFTPWorker.class);
    private final ServerThread server;
    private final DPCServer.Connection connection;
    private final UFTPTransferRequest job;
    public static final int BUFFSIZE = 16384;
    private final int maxStreams;
    private final int bufferSize;
    public final String multiFileTag = "___UFTP___MULTI___FILE___MODE___";

    public UFTPWorker(ServerThread server, DPCServer.Connection connection, UFTPTransferRequest job, int maxStreams, int bufferSize) {
        this.server = server;
        this.connection = connection;
        this.job = job;
        this.maxStreams = maxStreams;
        this.bufferSize = bufferSize;
    }

    @Override
    public void run() {
        String fileName = this.job.getFile().getName();
        if ("___UFTP___MULTI___FILE___MODE___".equals(fileName)) {
            this.runMulti();
        } else {
            this.runSingle();
        }
    }

    protected void runMulti() {
        throw new IllegalStateException("Not yet implemented");
    }

    protected void runSingle() {
        InputStream reader = null;
        OutputStream writer = null;
        Socket socket = null;
        FileAccess fileAccess = this.server.getFileAccess();
        long total = 0L;
        long maxBytes = Long.MAX_VALUE;
        String fileName = this.job.getFile().getAbsolutePath();
        if (fileName.startsWith("/dev/") && fileName.contains("_")) {
            String[] s = fileName.split("_");
            fileName = s[0];
            maxBytes = Long.parseLong(s[1]);
        }
        try {
            socket = this.makeSocket(this.maxStreams, this.connection);
            File file = new File(fileName).getCanonicalFile();
            String userID = this.job.getUser();
            String groupID = this.job.getGroup();
            byte[] buffer = new byte[16384];
            long time = System.currentTimeMillis();
            if (this.job.isSendJob()) {
                maxBytes = maxBytes != Long.MAX_VALUE ? maxBytes : file.length();
                logger.info("Sending " + maxBytes + " bytes from " + file.getAbsolutePath());
                reader = fileAccess.readFile(file.getAbsolutePath(), userID, groupID, this.bufferSize);
                writer = this.job.getKey() != null && !(socket instanceof PSocket) ? Utils.getEncryptStream(socket.getOutputStream(), this.job.getKey()) : socket.getOutputStream();
            } else {
                logger.info("Receiving " + file.getAbsolutePath());
                writer = fileAccess.writeFile(file.getAbsolutePath(), this.job.isAppend(), userID, groupID, this.bufferSize);
                reader = this.job.getKey() != null && !(socket instanceof PSocket) ? Utils.getDecryptStream(socket.getInputStream(), this.job.getKey()) : socket.getInputStream();
            }
            int n = 0;
            while (total < maxBytes && (n = reader.read(buffer)) >= 0) {
                writer.write(buffer, 0, n);
                total += (long)n;
            }
            writer.flush();
            logger.debug("Time: " + (System.currentTimeMillis() - time) + " total bytes transferred: " + total);
            if (!this.job.isSendJob()) {
                this.server.getFileAccess().setUser(file.getCanonicalPath(), userID, groupID);
            }
        }
        catch (Exception e) {
            logger.error("Error", e);
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException i) {
                // empty catch block
            }
        }
        this.cleanup(reader, writer);
    }

    private void cleanup(InputStream reader, OutputStream writer) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.warn("Error closing reader", e);
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            logger.warn("Error closing writer", e);
        }
        try {
            this.connection.close();
        }
        catch (IOException e) {
            logger.warn("Error closing connection.", e);
        }
        this.server.notifyConnectionClosed(this.connection.getAddress());
    }

    protected void sendData(File source, OutputStream target, byte[] buffer, long offset, long bytesToSend) throws IOException {
        RandomAccessFile ra = new RandomAccessFile(source, "r");
        ra.seek(offset);
        int bufSize = buffer.length;
        int n = 0;
        int len = 0;
        for (long total = 0L; total < bytesToSend && (n = ra.read(buffer, 0, len = (int)Math.min((long)bufSize, bytesToSend - total))) >= 0; total += (long)n) {
            target.write(buffer, 0, n);
        }
    }

    protected Socket makeSocket(int max, DPCServer.Connection connection) throws Exception {
        Socket socket = null;
        int n = Math.min(this.job.getNumCons(), max);
        if (n > 1) {
            logger.info("Creating parallel socket with " + n + " streams.");
            Socket[] dataCons = connection.openDataConnections(n);
            PSocket parallelSocket = new PSocket(this.job.getKey());
            parallelSocket.init(1, dataCons.length);
            for (int i = 0; i < dataCons.length; ++i) {
                parallelSocket.addSocketStream(dataCons[i]);
            }
            socket = parallelSocket;
        } else {
            socket = connection.openDataConnections(1)[0];
        }
        return socket;
    }

    public UFTPTransferRequest getJob() {
        return this.job;
    }
}

