/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.client;

import eu.unicore.uftp.client.SecretClientAuth;
import eu.unicore.uftp.client.UFTPProgressListener;
import eu.unicore.uftp.dpc.DPCClient;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.jparss.PSocket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class UFTPClient
implements Runnable {
    private static final Logger logger = Logger.getLogger(UFTPClient.class);
    public static final int SYNERR = 1;
    public static final int HOSTERR = 2;
    public static final int BUFFSIZE = 16384;
    private final InetAddress[] servers;
    private final int port;
    private int numcons = 1;
    private int timeout = 0;
    private int authtimeout = 0;
    private String secret;
    private int bufferSize = 131072;
    private final InputStream fileReadStream;
    private final OutputStream fileWriteStream;
    private final boolean send;
    private final String fileName;
    private byte[] key;
    private UFTPProgressListener progressListener = null;
    long maxBytes = Long.MAX_VALUE;

    public UFTPClient(InetAddress[] servers, int port, String fileName, boolean send, boolean append) throws FileNotFoundException {
        this.servers = servers;
        this.port = port;
        this.send = send;
        this.fileName = fileName;
        File file = new File(fileName);
        if (send) {
            String realFileName = file.getAbsolutePath();
            if (realFileName.startsWith("/dev/") && realFileName.contains("_")) {
                String[] s = realFileName.split("_");
                fileName = s[0];
                this.maxBytes = Long.parseLong(s[1]);
            }
            this.maxBytes = this.maxBytes != Long.MAX_VALUE ? this.maxBytes : file.length();
            logger.info("Sending " + realFileName + " length " + this.maxBytes);
            this.fileReadStream = new FileInputStream(realFileName);
            this.fileWriteStream = null;
        } else {
            logger.info("Writing to " + file.getAbsolutePath());
            this.fileWriteStream = new FileOutputStream(file, append);
            this.fileReadStream = null;
        }
    }

    public UFTPClient(InetAddress[] servers, int port, InputStream source) {
        this.servers = servers;
        this.port = port;
        this.send = true;
        this.fileName = null;
        this.fileReadStream = source;
        this.fileWriteStream = null;
    }

    public UFTPClient(InetAddress[] servers, int port, OutputStream target) {
        this.servers = servers;
        this.port = port;
        this.send = false;
        this.fileName = null;
        this.fileReadStream = null;
        this.fileWriteStream = target;
    }

    @Override
    public void run() {
        DPCClient client = new DPCClient();
        client.setTimeout(this.timeout);
        client.setAuthTimeout(this.authtimeout);
        InputStream reader = null;
        OutputStream writer = null;
        try {
            logger.info("Connecting...");
            client.connect(this.servers, this.port, new SecretClientAuth(this.secret));
            Socket socket = this.createSocket(this.numcons, client, this.key);
            if (this.send) {
                if (this.key != null && this.numcons == 1) {
                    logger.info("Writing encrypted data.");
                    writer = Utils.getEncryptStream(socket.getOutputStream(), this.key);
                } else {
                    writer = socket.getOutputStream();
                }
                reader = this.fileReadStream;
            } else {
                if (this.key != null && this.numcons == 1) {
                    logger.info("Reading encrypted data.");
                    reader = Utils.getDecryptStream(socket.getInputStream(), this.key);
                } else {
                    reader = socket.getInputStream();
                }
                writer = this.fileWriteStream;
            }
            byte[] buffer = new byte[16384];
            long time = System.currentTimeMillis();
            int n = 0;
            long total = 0L;
            boolean notify = this.progressListener != null;
            long c = 0L;
            while (total < this.maxBytes && (n = reader.read(buffer)) >= 0) {
                total += (long)n;
                writer.write(buffer, 0, n);
                if (!notify) continue;
                if (c % 1000L == 0L) {
                    this.progressListener.notifyTotalBytesTransferred(total);
                }
                ++c;
            }
            writer.flush();
            if (notify) {
                this.progressListener.notifyTotalBytesTransferred(total);
            }
            time = System.currentTimeMillis() - time;
            double rate = (double)total / (double)time;
            logger.info("Finished, data rate " + (int)rate + " kB/sec. (" + total + " bytes in " + time + " ms.)");
        }
        catch (Exception e) {
            throw new RuntimeException("Error running transfer", e);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.warn("Error closing reader.", e);
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            logger.warn("Error closing writer.", e);
        }
        try {
            client.close();
        }
        catch (IOException e) {
            logger.warn("Error closing DPC client.", e);
        }
    }

    protected Socket createSocket(int numConnections, DPCClient client, byte[] key) throws Exception {
        Socket socket = null;
        if (numConnections > 1) {
            logger.info("Creating parallel socket with " + numConnections + " streams.");
            Socket[] dataCons = client.openDataConnections(numConnections);
            PSocket parallelSocket = new PSocket(key);
            parallelSocket.init(1, dataCons.length);
            for (int i = 0; i < dataCons.length; ++i) {
                parallelSocket.addSocketStream(dataCons[i]);
            }
            socket = parallelSocket;
        } else {
            socket = client.openDataConnections(1)[0];
        }
        return socket;
    }

    public void setNumConnections(int num) {
        if (num < 1) {
            throw new IllegalArgumentException();
        }
        this.numcons = num;
    }

    public int getNumConnections() {
        return this.numcons;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getAuthtimeout() {
        return this.authtimeout;
    }

    public void setAuthtimeout(int authtimeout) {
        this.authtimeout = authtimeout;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public byte[] getKey() {
        return this.key;
    }

    public UFTPProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(UFTPProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    String getFile() {
        return this.fileName;
    }

    InetAddress[] getServerList() {
        return this.servers;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public static void main(String[] args) throws Exception {
        try {
            UFTPClient client = UFTPClient.create(args);
            client.run();
            System.exit(0);
        }
        catch (Exception ex) {
            logger.error("Error running UFTP client", ex);
            System.err.println("Error running UFTP client: " + ex.getMessage());
            if (ex.getCause() instanceof ProtocolViolationException) {
                System.err.println();
                System.err.println("Please check hostname and port of the remote server!");
            }
            System.exit(1);
        }
    }

    static UFTPClient create(String[] args) throws UnknownHostException, FileNotFoundException {
        String bufSize;
        String[] servers;
        Options options = UFTPClient.createOptions();
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            System.out.println();
            UFTPClient.printUsage(options);
            System.exit(1);
        }
        boolean send = true;
        ArrayList<InetAddress> serverList = new ArrayList<InetAddress>();
        int port = 0;
        int numcons = 0;
        UFTPClient client = null;
        if (line.hasOption("s")) {
            send = true;
        } else if (line.hasOption("r")) {
            send = false;
        }
        for (String s : servers = line.getOptionValue("l").split("[ ,]+")) {
            try {
                InetAddress a = InetAddress.getByName(s);
                serverList.add(a);
            }
            catch (UnknownHostException uhe) {
                logger.debug("No such host: " + s);
            }
        }
        port = Integer.parseInt(line.getOptionValue("L"));
        numcons = Integer.parseInt(line.getOptionValue("n"));
        String file = line.getOptionValue("f");
        boolean append = Boolean.parseBoolean(line.getOptionValue("a"));
        InetAddress[] server = serverList.toArray(new InetAddress[serverList.size()]);
        client = new UFTPClient(server, port, file, send, append);
        client.setNumConnections(numcons);
        client.setSecret(line.getOptionValue("x"));
        String keyBase64 = line.getOptionValue("E");
        if (keyBase64 != null) {
            client.setKey(Utils.decodeBase64(keyBase64));
        }
        if ((bufSize = line.getOptionValue("b")) != null) {
            client.setBufferSize(Integer.parseInt(bufSize) * 1024);
        }
        logger.info("New UFTP client for server " + Arrays.asList(server) + " at port " + port);
        return client;
    }

    public static String makeCommandline(String host, int port, String localFile, boolean sendData, String secret, int numStreams, String encryptionKey, boolean append, int bufferSize) {
        String c1 = UFTPClient.makeCommandline(host, port, localFile, sendData, secret, numStreams, encryptionKey, append);
        return c1 + " -b " + bufferSize;
    }

    public static String makeCommandline(String host, int port, String localFile, boolean sendData, String secret, int numStreams, String encryptionKey, boolean append) {
        StringBuilder sb = new StringBuilder();
        sb.append("-l ").append(host);
        sb.append(" -L ").append(port);
        sb.append(" -f \"").append(localFile).append("\"");
        if (sendData) {
            sb.append(" -s");
        } else {
            sb.append(" -r");
        }
        sb.append(" -x ").append(secret);
        sb.append(" -n ").append(numStreams);
        if (encryptionKey != null) {
            sb.append(" -E ");
            sb.append(encryptionKey);
        }
        if (append) {
            sb.append(" -a");
        }
        return sb.toString();
    }

    public static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt("send");
        OptionBuilder.withDescription("Send data");
        OptionBuilder.withArgName("Send");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create("s"));
        OptionBuilder.withLongOpt("receive");
        OptionBuilder.withDescription("Receive data");
        OptionBuilder.withArgName("Receive");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create("r"));
        OptionBuilder.withLongOpt("listen-host");
        OptionBuilder.withDescription("Hostname of the server socket");
        OptionBuilder.withArgName("Server host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create("l"));
        OptionBuilder.withLongOpt("listen-port");
        OptionBuilder.withDescription("Port of the server socket");
        OptionBuilder.withArgName("Server port");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create("L"));
        OptionBuilder.withLongOpt("file");
        OptionBuilder.withDescription("Local file name");
        OptionBuilder.withArgName("File name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create("f"));
        OptionBuilder.withLongOpt("secret");
        OptionBuilder.withDescription("Authorisation secret");
        OptionBuilder.withArgName("Secret");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create("x"));
        OptionBuilder.withLongOpt("streams");
        OptionBuilder.withDescription("Number of streams");
        OptionBuilder.withArgName("Streams");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create("n"));
        OptionBuilder.withLongOpt("encryption-key");
        OptionBuilder.withDescription("Encryption key, Base64-encoded");
        OptionBuilder.isRequired(false);
        OptionBuilder.withArgName("base64Key");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("E"));
        OptionBuilder.withLongOpt("append");
        OptionBuilder.withDescription("Append to an existing file");
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create("a"));
        OptionBuilder.withLongOpt("buffersize");
        OptionBuilder.withDescription("Buffer size in kbytes for reading/writing files (default 128)");
        OptionBuilder.withArgName("bufferSize");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(false);
        options.addOption(OptionBuilder.create("b"));
        return options;
    }

    public static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String syntax = "UFTPClient [OPTIONS]" + System.getProperty("line.separator");
        formatter.printHelp(syntax, options);
    }
}

