/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.unicore.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.fault.FaultInfoException;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.OperationInfo;

public class ReliableProxy
implements InvocationHandler {
    private static final Logger log = Log.getLogger("unicore.client", ReliableProxy.class);
    private int failedSubmits = 0;
    private Integer maxSubmits = 3;
    private final Client client;
    protected RetryDecider retryDecider;

    public ReliableProxy(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public void setRetryDecider(RetryDecider handler) {
        this.retryDecider = handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int n = 0;
        Throwable cause = null;
        while (true) {
            try {
                return this.doInvoke(proxy, method, args);
            }
            catch (Throwable t) {
                log.debug("Error making call for " + method.getName() + " on " + this.client.getUrl(), t);
                cause = t;
                ++this.failedSubmits;
                if (this.retryDecider != null && this.retryDecider.retry(method, cause, ++n)) continue;
                throw cause;
            }
            break;
        }
    }

    protected Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (log.isDebugEnabled()) {
            log.debug("Method [" + methodName + "] " + (args == null ? "" : Arrays.asList(args).toString()));
        }
        if ((result = this.handleCanonicalMethods(methodName, parameterTypes, args)) == null) {
            result = this.handleRequest(method, args);
        }
        if (log.isDebugEnabled()) {
            log.debug("Result [" + String.valueOf(result) + "]");
        }
        return result;
    }

    private Object handleRequest(Method m, Object[] args) throws Exception {
        OperationInfo op = this.client.getService().getServiceInfo().getOperation(m);
        if (op == null) {
            op = this.client.getService().getServiceInfo().getOperation(m.getName());
        }
        try {
            Object[] response = this.client.invoke(op, args);
            if (response != null && response.length > 0) {
                return response[0];
            }
            return null;
        }
        catch (Exception e) {
            if (this.isDeclared(e, m)) {
                throw e;
            }
            throw new XFireRuntimeException("Could not invoke service.", e);
        }
    }

    private boolean isDeclared(Exception e, Method m) {
        Class<?>[] types = m.getExceptionTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isAssignableFrom(e.getClass())) continue;
            return true;
        }
        return false;
    }

    private Object handleCanonicalMethods(String methodName, Class<?>[] params, Object[] args) {
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object other = args[0];
            if (other == null || !Proxy.isProxyClass(other.getClass()) || !(Proxy.getInvocationHandler(other) instanceof ReliableProxy)) {
                return Boolean.FALSE;
            }
            ReliableProxy otherClient = (ReliableProxy)Proxy.getInvocationHandler(other);
            return otherClient == this;
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this.hashCode());
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "XFireReliableProxy[" + this.client.getUrl() + "]";
        }
        return null;
    }

    public Integer getMaxSubmits() {
        return this.maxSubmits;
    }

    public void setMaxSubmits(int maxSubmits) {
        this.maxSubmits = maxSubmits;
    }

    public int getFailedSubmits() {
        return this.failedSubmits;
    }

    public static RetryDecider getDefaultDecider(final ReliableProxy parent) {
        return new RetryDecider(){

            @Override
            public boolean retry(Method m, Throwable error, int numberOfUnsuccessfulTries) {
                if (error instanceof XFireFault || error instanceof FaultInfoException) {
                    return false;
                }
                return numberOfUnsuccessfulTries < parent.getMaxSubmits();
            }
        };
    }

    public static interface RetryDecider {
        public boolean retry(Method var1, Throwable var2, int var3);
    }
}

