/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil.client;

import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.xfireutil.client.TDOutHandler;
import eu.unicore.security.xfireutil.client.XFireClientFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.codehaus.xfire.client.Client;

public class ClientTrustDelegationUtil {
    public static void addTrustDelegation(Object xfireProxy, List<TrustDelegation> tdChain) {
        Client xfireClient = XFireClientFactory.getXfireClient(xfireProxy);
        ClientTrustDelegationUtil.addTrustDelegation(xfireClient, tdChain);
    }

    public static void addTrustDelegation(Client xfireClient, List<TrustDelegation> tdChain) {
        if (tdChain == null || tdChain.size() == 0) {
            throw new IllegalArgumentException("Trust delegation chain can't be null/empty");
        }
        TrustDelegation td1 = tdChain.get(0);
        TrustDelegation tdLast = tdChain.get(tdChain.size() - 1);
        ClientTrustDelegationUtil.addTrustDelegation(xfireClient, tdChain, td1.getIssuerFromSignature(), tdLast.getSubjectDN());
    }

    public static void addTrustDelegation(Object xfireProxy, List<TrustDelegation> tdChain, X509Certificate[] user, String callerDN) {
        Client xfireClient = XFireClientFactory.getXfireClient(xfireProxy);
        ClientTrustDelegationUtil.addTrustDelegation(xfireClient, tdChain, user, callerDN);
    }

    public static void addTrustDelegation(Client xfireClient, List<TrustDelegation> tdChain, X509Certificate[] userCert, String callerDN) {
        ClientTrustDelegationUtil.addTrustDelegation(xfireClient, tdChain, userCert, null, callerDN);
    }

    public static void addTrustDelegation(Object xfireProxy, List<TrustDelegation> tdChain, String userDN, String callerDN) {
        Client xfireClient = XFireClientFactory.getXfireClient(xfireProxy);
        ClientTrustDelegationUtil.addTrustDelegation(xfireClient, tdChain, null, userDN, callerDN);
    }

    public static void addTrustDelegation(Client xfireClient, List<TrustDelegation> tdChain, String userDN, String callerDN) {
        ClientTrustDelegationUtil.addTrustDelegation(xfireClient, tdChain, null, userDN, callerDN);
    }

    private static void addTrustDelegation(Client xfireClient, List<TrustDelegation> tdChain, X509Certificate[] user, String userDN, String callerDN) {
        List outHandlers = xfireClient.getOutHandlers();
        TDOutHandler tdHandler = null;
        for (Object h : outHandlers) {
            if (!(h instanceof TDOutHandler)) continue;
            tdHandler = (TDOutHandler)h;
            break;
        }
        if (tdHandler != null) {
            outHandlers.remove(tdHandler);
        }
        tdHandler = userDN == null ? new TDOutHandler(tdChain, user, callerDN) : new TDOutHandler(tdChain, userDN, callerDN);
        xfireClient.addOutHandler(tdHandler);
    }

    public static void removeTrustDelegation(Object xfireProxy) {
        Client xfireClient = XFireClientFactory.getXfireClient(xfireProxy);
        ClientTrustDelegationUtil.removeTrustDelegation(xfireClient);
    }

    public static void removeTrustDelegation(Client xfireClient) {
        List outHandlers = xfireClient.getOutHandlers();
        for (int i = outHandlers.size() - 1; i >= 0; --i) {
            Object h = outHandlers.get(i);
            if (!(h instanceof TDOutHandler)) continue;
            outHandlers.remove(i);
        }
    }
}

