/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.canl;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.DERCredential;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.KeystoreCredential;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CredentialProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger("unicore.configuration", CredentialProperties.class);
    private static final long WEEK = 604800000L;
    public static final String DEFAULT_PREFIX = "credential.";
    public static final String PROP_FORMAT = "format";
    public static final String PROP_LOCATION = "path";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_KEY_LOCATION = "keyPath";
    public static final String PROP_KS_ALIAS = "keyAlias";
    public static final String PROP_KS_KEY_PASSWORD = "keyPassword";
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
    private CredentialFormat type;
    private String credPath;
    private X509Credential credential;
    private PasswordCallback passwordCallback;

    public CredentialProperties(Properties properties) throws ConfigurationException {
        this(properties, null, DEFAULT_PREFIX);
    }

    public CredentialProperties(Properties properties, String pfx) throws ConfigurationException {
        this(properties, null, pfx);
    }

    public CredentialProperties(Properties properties, PasswordCallback callback) throws ConfigurationException {
        this(properties, callback, DEFAULT_PREFIX);
    }

    public CredentialProperties(Properties properties, PasswordCallback callback, String pfx) throws ConfigurationException {
        super(pfx, properties, META, log);
        this.passwordCallback = callback;
        this.createCredentialSafe();
    }

    public X509Credential getCredential() {
        return this.credential;
    }

    private void createCredentialSafe() throws ConfigurationException {
        try {
            this.createCredential();
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("There was a problem loading the credential " + this.credPath + " (type: " + (Object)((Object)this.type) + "): " + e.getMessage(), e);
        }
        X509Certificate cert = this.credential.getCertificate();
        try {
            cert.checkValidity();
            try {
                cert.checkValidity(new Date(System.currentTimeMillis() + 604800000L));
            }
            catch (CertificateExpiredException ce) {
                String date = cert.getNotAfter().toString();
                log.warn("Credential certificate with DN " + X500NameUtils.getReadableForm(cert.getSubjectX500Principal()) + " will soon expire. The validity period ends " + date);
            }
        }
        catch (CertificateExpiredException e) {
            throw new ConfigurationException("Certificate loaded from " + this.credPath + " (" + CertificateUtils.format(cert, FormatMode.COMPACT_ONE_LINE) + ") " + " is EXPIRED: " + e.getMessage());
        }
        catch (CertificateNotYetValidException e) {
            throw new ConfigurationException("Certificate loaded from " + this.credPath + " (" + CertificateUtils.format(cert, FormatMode.COMPACT_ONE_LINE) + ") " + " is NOT YED VALID: " + e.getMessage());
        }
    }

    private void createCredential() throws ConfigurationException, KeyStoreException, IOException, CertificateException {
        this.credPath = this.getFileValueAsString(PROP_LOCATION, false);
        File ks = new File(this.credPath);
        if (!(ks.exists() && ks.canRead() && ks.isFile())) {
            throw new ConfigurationException("Credential specified in the property " + this.prefix + PROP_LOCATION + " must be an EXISTING, READABLE file: " + this.credPath);
        }
        boolean preferCallback = this.passwordCallback != null && this.passwordCallback.ignoreProperties();
        char[] credPassword = null;
        if (!preferCallback) {
            String pass = this.getValue(PROP_PASSWORD);
            char[] cArray = credPassword = pass == null ? null : pass.toCharArray();
        }
        if (credPassword == null && this.passwordCallback != null) {
            credPassword = this.passwordCallback.getPassword("credential", this.credPath);
        }
        String keyLocation = this.getFileValueAsString(PROP_KEY_LOCATION, false);
        String ksAlias = this.getValue(PROP_KS_ALIAS);
        char[] ksKeyPassword = null;
        if (!preferCallback) {
            String pass = this.getValue(PROP_KS_KEY_PASSWORD);
            ksKeyPassword = pass == null ? null : pass.toCharArray();
        }
        this.type = this.getEnumValue(PROP_FORMAT, CredentialFormat.class);
        if (this.type == null) {
            this.type = this.autodetectType(this.credPath, credPassword, keyLocation, ksAlias, ksKeyPassword);
            log.info("Will use autodetected credential type >" + (Object)((Object)this.type) + "< for " + this.credPath);
        }
        if (this.type.equals((Object)CredentialFormat.jks) || this.type.equals((Object)CredentialFormat.pkcs12)) {
            log.debug("Credential keystore alias: " + (ksAlias == null ? "NOT-SET" : ksAlias));
            if (credPassword == null) {
                throw new ConfigurationException("For " + (Object)((Object)this.type) + " credential, the " + this.prefix + PROP_PASSWORD + " property must be set and provide a keystore password");
            }
            if (ksKeyPassword == null && this.passwordCallback != null && this.passwordCallback.askForSeparateKeyPassword()) {
                ksKeyPassword = this.passwordCallback.getPassword("credential's key", this.credPath);
            }
            if (ksKeyPassword == null) {
                log.debug("Using keystore password as key's password");
                ksKeyPassword = credPassword;
            }
            this.credential = new KeystoreCredential(this.credPath, credPassword, ksKeyPassword, ksAlias, this.type.name());
        } else if (this.type.equals((Object)CredentialFormat.pem)) {
            this.credential = keyLocation == null ? new PEMCredential(this.credPath, credPassword) : new PEMCredential(keyLocation, this.credPath, credPassword);
        } else if (this.type.equals((Object)CredentialFormat.der)) {
            if (keyLocation == null) {
                throw new ConfigurationException("For " + (Object)((Object)CredentialFormat.der) + " credential, the " + this.prefix + PROP_KEY_LOCATION + " property must be set and point at the DER encoded private key.");
            }
            this.credential = new DERCredential(keyLocation, this.credPath, credPassword);
        } else {
            throw new ConfigurationException("Unknown type of credential used: " + (Object)((Object)this.type) + " must be one of: " + Arrays.toString((Object[])CredentialFormat.values()));
        }
    }

    private CredentialFormat autodetectType(String credPath, char[] credPassword, String keyLocation, String ksAlias, char[] ksKeyPassword) {
        String errorPfx = "Credential type was not set with the property " + this.prefix + PROP_FORMAT;
        if (keyLocation != null && (ksAlias != null || ksKeyPassword != null)) {
            new ConfigurationException(errorPfx + " and settings for both " + (Object)((Object)CredentialFormat.pem) + " and JKS/PKCS12 keystore are present." + " Either set the type explicitely or delete settings of not used credential type (" + PROP_KEY_LOCATION + " or " + PROP_KS_ALIAS + " and " + PROP_KS_KEY_PASSWORD + ")");
        }
        if (ksAlias != null || ksKeyPassword != null || keyLocation == null) {
            if (credPath.toLowerCase().endsWith("pem")) {
                return CredentialFormat.pem;
            }
            try {
                String type = KeystoreCredential.autodetectType(credPath, credPassword);
                if (type.equalsIgnoreCase("jks")) {
                    return CredentialFormat.jks;
                }
                if (type.equalsIgnoreCase("pkcs12")) {
                    return CredentialFormat.pkcs12;
                }
                throw new ConfigurationException("Unknown keystore type found: " + type);
            }
            catch (KeyStoreException e) {
                throw new ConfigurationException(errorPfx + ". Tried to load JKS/PKCS12 keystore as " + "settings for those types are present, but it was not possible. " + "Try to set the credential format explicitely and/or to review other credential settings.");
            }
            catch (IOException e) {
                throw new ConfigurationException(errorPfx + ". Tried to load JKS/PKCS12 keystore as " + "settings for those types are present, but it was not possible. " + "Try to set the credential format explicitely and/or to review other credential settings. " + "Cause: " + e.toString());
            }
        }
        if (credPath.endsWith("der") || keyLocation != null && keyLocation.endsWith("der") || credPath.endsWith("pkcs8") || credPath.endsWith("pk8")) {
            return CredentialFormat.der;
        }
        return CredentialFormat.pem;
    }

    @Override
    public CredentialProperties clone() {
        CredentialProperties ret = new CredentialProperties(this.properties, this.passwordCallback, this.prefix);
        super.cloneTo(ret);
        return ret;
    }

    static {
        META.put(PROP_LOCATION, new PropertyMD().setMandatory().setSortKey("1").setDescription("Credential location. In case of 'jks', 'pkcs12' and 'pem' store it is the only location required. In case when credential is provided in two files, it is the certificate file path.").setPath());
        META.put(PROP_FORMAT, new PropertyMD().setEnum(CredentialFormat.jks).setSortKey("2").setDescription("Format of the credential. It is guessed when not given. Note that 'pem' might be either a PEM keystore with certificates and keys (in PEM format) or a pair of PEM files (one with certificate and second with private key)."));
        META.put(PROP_PASSWORD, new PropertyMD().setSecret().setSortKey("3").setDescription("Password required to load the credential."));
        META.put(PROP_KEY_LOCATION, new PropertyMD().setSortKey("4").setDescription("Location of the private key if stored separately from the main credential (applicable for 'pem' and 'der' types only),"));
        META.put(PROP_KS_KEY_PASSWORD, new PropertyMD().setSecret().setSortKey("5").setDescription("Private key password, which might be needed only for 'jks' or 'pkcs12', if key is encrypted with different password then the main credential password."));
        META.put(PROP_KS_ALIAS, new PropertyMD().setSortKey("6").setDescription("Keystore alias of the key entry to be used. Can be ignored if the keystore contains only one key entry. Only applicable for 'jks' and 'pkcs12'."));
    }

    public static enum CredentialFormat {
        jks,
        pkcs12,
        der,
        pem;

    }
}

