/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.Queue;
import eu.unicore.security.Role;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.Xlogin;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Client
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ATTRIBUTE_CREDENTIALS_USERNAME = "creds.username";
    public static final String ATTRIBUTE_CREDENTIALS_PASSWORD = "creds.password";
    public static final String ATTRIBUTE_USER_EMAIL = "user.email";
    public static final String ANONYMOUS_CLIENT_DN = "CN=ANONYMOUS,O=UNKNOWN,OU=UNKNOWN";
    public static final String LOCAL_CLIENT_DN = "CN=Local_call";
    private SecurityTokens secTokens;
    private Type type;
    private Xlogin xlogin;
    private Role role;
    private String[] vos;
    private String vo;
    private Queue queue;
    private SubjectAttributesHolder subjectAttributes;
    private final Map<String, Serializable> extraAttributes;

    public Client() {
        this.setAnonymousClient();
        this.extraAttributes = new HashMap<String, Serializable>();
        this.setSubjectAttributes(new SubjectAttributesHolder());
        this.xlogin = new Xlogin();
        this.role = new Role();
        this.vos = new String[0];
        this.queue = new Queue();
    }

    public String toString() {
        StringBuilder cInfo = new StringBuilder();
        cInfo.append("Name: ");
        cInfo.append(X500NameUtils.getReadableForm(this.getDistinguishedName()));
        cInfo.append("\nXlogin: ");
        cInfo.append(this.getXlogin());
        cInfo.append("\nRole: ");
        cInfo.append(this.getRole());
        if (this.queue.getValidQueues().length > 0) {
            cInfo.append("\nQueues: ");
            cInfo.append(this.queue);
        }
        if (this.vos.length > 0) {
            cInfo.append("\nVOs: ");
            cInfo.append(Arrays.toString(this.vos));
        }
        if (this.vo != null) {
            cInfo.append("\nSelected VO: ").append(this.vo);
        }
        if (this.secTokens != null) {
            cInfo.append("\nSecurity tokens: ");
            cInfo.append(this.secTokens);
        }
        return cInfo.toString();
    }

    public Type getType() {
        return this.type;
    }

    public void setAnonymousClient() {
        this.type = Type.ANONYMOUS;
        this.secTokens = null;
    }

    public void setLocalClient() {
        this.type = Type.LOCAL;
        this.secTokens = null;
    }

    public void setAuthenticatedClient(SecurityTokens secTokens) {
        this.secTokens = secTokens;
        if (secTokens == null || secTokens.getEffectiveUserName() == null) {
            this.type = Type.ANONYMOUS;
            return;
        }
        this.type = Type.AUTHENTICATED;
    }

    public SecurityTokens getSecurityTokens() {
        return this.secTokens;
    }

    public String getDistinguishedName() {
        if (this.type == Type.ANONYMOUS) {
            return ANONYMOUS_CLIENT_DN;
        }
        if (this.type == Type.LOCAL) {
            return LOCAL_CLIENT_DN;
        }
        return this.secTokens.getEffectiveUserName().getName();
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Map<String, Serializable> getExtraAttributes() {
        return this.extraAttributes;
    }

    public Xlogin getXlogin() {
        return this.xlogin;
    }

    public void setXlogin(Xlogin xlogin) {
        if (xlogin == null) {
            throw new IllegalArgumentException("Setting null xlogin is prohibited.");
        }
        this.xlogin = xlogin;
    }

    public String getSelectedXloginName() {
        return this.xlogin.getUserName();
    }

    public void setSelectedXloginName(String userName) {
        this.xlogin.setSelectedLogin(userName);
    }

    public String getUserEmail() {
        return (String)((Object)this.extraAttributes.get(ATTRIBUTE_USER_EMAIL));
    }

    public void setUserEmail(String email) {
        if (email == null) {
            this.extraAttributes.remove(ATTRIBUTE_USER_EMAIL);
        }
        this.extraAttributes.put(ATTRIBUTE_USER_EMAIL, (Serializable)((Object)email));
    }

    public void setSubjectAttributes(SubjectAttributesHolder subjectAttributes) {
        this.subjectAttributes = subjectAttributes;
    }

    public SubjectAttributesHolder getSubjectAttributes() {
        return this.subjectAttributes;
    }

    public String[] getVos() {
        return this.vos;
    }

    public void setVos(String[] vos) {
        if (vos == null) {
            throw new IllegalArgumentException("Can not set null VOs array, use empty array instead");
        }
        this.vos = vos;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        if (queue == null) {
            throw new IllegalArgumentException("Can not set null Queue object, use empty Queue instead");
        }
        this.queue = queue;
    }

    public String getVo() {
        return this.vo;
    }

    public void setVo(String vo) {
        for (String v : this.vos) {
            if (!v.equals(vo)) continue;
            this.vo = vo;
            return;
        }
        throw new IllegalArgumentException("The selected VO '" + vo + "' is not one of the VOs the client is memeber of");
    }

    public static enum Type {
        AUTHENTICATED,
        ANONYMOUS,
        LOCAL;

    }
}

