/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.protocol.AuthnRequestDocument;
import xmlbeans.org.oasis.saml2.protocol.NameIDPolicyType;

public class AuthnRequest
extends AbstractRequest {
    private AuthnRequestDocument xbdoc;

    public AuthnRequest(AuthnRequestDocument src) throws SAMLProtocolException {
        super(src.getAuthnRequest());
        this.xbdoc = src;
        this.parse();
    }

    public AuthnRequest(NameID issuer) {
        this.xbdoc = AuthnRequestDocument.Factory.newInstance();
        this.init(this.xbdoc.addNewAuthnRequest(), issuer);
    }

    public void setFormat(String format) {
        NameIDPolicyType policy = this.xbdoc.getAuthnRequest().addNewNameIDPolicy();
        policy.setFormat(format);
    }

    public void setConsumerURL(String consumerURL) {
        this.xbdoc.getAuthnRequest().setAssertionConsumerServiceURL(consumerURL);
    }

    @Override
    public AuthnRequestDocument getDoc() {
        return this.xbdoc;
    }

    @Override
    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        return this.isCorrectlySigned(key, (Document)this.xbdoc.getDomNode());
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xbdoc = AuthnRequestDocument.Factory.parse(doc);
            this.xmlReq = this.xbdoc.getAuthnRequest();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }
}

