/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.job.model;

import eu.unicore.hila.job.model.Export;
import eu.unicore.hila.job.model.Import;
import eu.unicore.hila.job.model.StageIn;
import eu.unicore.hila.job.model.StageOut;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class JobModel {
    private List<Import> imports = new ArrayList<Import>();
    private List<Export> exports = new ArrayList<Export>();
    private String taskName;
    private String applicationName = null;
    private String applicationVersion = null;
    private String applicationDescription = null;
    private String executable = null;
    private List<String> arguments = new ArrayList<String>();
    private Map<String, String> environment = new HashMap<String, String>();
    private long lastModified;
    private ResourcesType resources;
    private List<String> jobAnnotations = new ArrayList<String>();
    private String description = null;
    private List<String> jobProjects = new ArrayList<String>();
    private List<StageOut> stageouts;
    private List<StageIn> stageIns = new ArrayList<StageIn>();
    private String stdout = null;
    private String stderr = null;
    private String stdin = null;
    private boolean clientDataPush = true;

    public JobModel() {
        this.stageouts = new ArrayList<StageOut>();
        this.lastModified = System.currentTimeMillis();
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public void setImports(List<Import> imports) {
        this.reset();
        this.imports = imports;
    }

    private void reset() {
        this.lastModified = System.currentTimeMillis();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public List<Export> getExports() {
        return this.exports;
    }

    public void setExports(List<Export> exports) {
        this.reset();
        this.exports = exports;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.reset();
        if (applicationName != null) {
            this.executable = null;
            this.applicationName = applicationName;
        }
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.reset();
        this.applicationVersion = applicationVersion;
    }

    public void setApplicationDescription(String _applicationDescription) {
        this.applicationDescription = _applicationDescription;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.reset();
        if (executable != null) {
            this.applicationName = null;
            this.executable = executable;
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.reset();
        this.arguments = arguments;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.reset();
        this.environment = environment;
    }

    public void setResources(ResourcesType _resources) {
        this.reset();
        this.resources = _resources;
    }

    public ResourcesType getResources() {
        return this.resources;
    }

    public void addArgument(String argument) {
        this.reset();
        this.arguments.add(argument);
    }

    public void addEnvironment(String variable, String value) {
        this.reset();
        this.environment.put(variable, value);
    }

    public void addExport(String _fileName, File _localFile) {
        this.reset();
        this.exports.add(new Export(_fileName, _localFile));
    }

    public void addExport(File _localFile) {
        this.reset();
        this.exports.add(new Export(_localFile.getName(), _localFile));
    }

    public void addImport(File _localFile, String _filename) {
        this.reset();
        this.imports.add(new Import(_localFile, _filename));
    }

    public void addImport(File _localFile) {
        this.addImport(_localFile, _localFile.getName());
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String _taskName) {
        this.reset();
        this.taskName = _taskName;
    }

    public void addJobAnnotation(String _annotation) {
        this.reset();
        this.jobAnnotations.add(_annotation);
    }

    public List<String> getJobAnnotations() {
        return this.jobAnnotations;
    }

    public void setJobDescription(String _description) {
        this.reset();
        this.description = _description;
    }

    public String getJobDescription() {
        return this.description;
    }

    public void addJobProject(String _project) {
        this.jobProjects.add(_project);
    }

    public List<StageOut> getStageOuts() {
        return this.stageouts;
    }

    public List<StageIn> getStageIns() {
        return this.stageIns;
    }

    public void addStageOut(StageOut stageout) {
        this.stageouts.add(stageout);
    }

    public void addStageIn(StageIn stageIn) {
        this.stageIns.add(stageIn);
    }

    public String getStdout() {
        return this.stdout;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public String getStdin() {
        return this.stdin;
    }

    public void setStdin(String stdin) {
        this.stdin = stdin;
    }

    public boolean isClientDataPush() {
        return this.clientDataPush;
    }

    public void setClientDataPush(boolean clientDataPush) {
        this.clientDataPush = clientDataPush;
    }
}

