/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.job.emi;

import eu.emi.es.x2010.x12.adl.ActivityDescriptionDocument;
import eu.emi.es.x2010.x12.adl.InputFileDocument;
import eu.emi.es.x2010.x12.adl.OptionType;
import eu.emi.es.x2010.x12.adl.OutputFileDocument;
import eu.emi.es.x2010.x12.adl.ResourcesDocument;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.StageIn;
import eu.unicore.hila.job.model.StageOut;
import eu.unicore.hila.job.spi.NativeToModel;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CPUArchitectureType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ProcessorArchitectureEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class EmiAdlToModel
implements NativeToModel {
    private ActivityDescriptionDocument adl;
    private JobModel model = null;

    public EmiAdlToModel(Object _adl) {
        this.adl = (ActivityDescriptionDocument)_adl;
    }

    @Override
    public synchronized JobModel getModel() {
        if (this.model == null) {
            this.createModel();
        }
        return this.model;
    }

    private void createModel() {
        this.model = new JobModel();
        ActivityDescriptionDocument.ActivityDescription activity = this.adl.getActivityDescription();
        if (activity.getActivityIdentification() != null) {
            if (activity.getActivityIdentification().isSetDescription()) {
                this.model.setJobDescription(activity.getActivityIdentification().getDescription());
            }
            if (activity.getActivityIdentification().isSetName()) {
                this.model.setTaskName(activity.getActivityIdentification().getName());
            }
            if (activity.getActivityIdentification().getAnnotationArray() != null && activity.getActivityIdentification().getAnnotationArray().length > 0) {
                for (String annotation : activity.getActivityIdentification().getAnnotationArray()) {
                    this.model.addJobAnnotation(annotation);
                }
            }
        }
        if (activity.isSetApplication() && activity.getApplication().isSetExecutable()) {
            this.model.setExecutable(activity.getApplication().getExecutable().getPath());
            if (activity.getApplication().getExecutable().getArgumentArray() != null && activity.getApplication().getExecutable().getArgumentArray().length > 0) {
                for (String argument : activity.getApplication().getExecutable().getArgumentArray()) {
                    this.model.addArgument(argument);
                }
            }
            if (activity.getApplication().getEnvironmentArray() != null && activity.getApplication().getEnvironmentArray().length > 0) {
                for (OptionType option : activity.getApplication().getEnvironmentArray()) {
                    this.model.addEnvironment(option.getName(), option.getValue());
                }
            }
        }
        if (activity.isSetApplication()) {
            if (activity.getApplication().getOutput() != null) {
                this.model.setStdout(activity.getApplication().getOutput());
            }
            if (activity.getApplication().getError() != null) {
                this.model.setStderr(activity.getApplication().getError());
            }
            if (activity.getApplication().getInput() != null) {
                this.model.setStdin(activity.getApplication().getInput());
            }
        }
        if (activity.isSetDataStaging()) {
            if (activity.getDataStaging().getInputFileArray() != null && activity.getDataStaging().getInputFileArray().length > 0) {
                for (InputFileDocument.InputFile inputFile : activity.getDataStaging().getInputFileArray()) {
                    this.model.addStageIn(new StageIn(inputFile.getName(), inputFile.getSourceArray(0).getURI(), null, null, false));
                }
            }
            if (activity.getDataStaging().getOutputFileArray() != null && activity.getDataStaging().getOutputFileArray().length > 0) {
                for (OutputFileDocument.OutputFile outputFile : activity.getDataStaging().getOutputFileArray()) {
                    this.model.addStageOut(new StageOut(outputFile.getName(), outputFile.getTargetArray(0).getURI(), null, null, false));
                }
            }
            if (activity.getDataStaging().isSetClientDataPush()) {
                this.model.setClientDataPush(activity.getDataStaging().getClientDataPush());
            }
        }
        if (activity.isSetResources()) {
            ResourcesDocument.Resources res = activity.getResources();
            ResourcesType jsdlRes = ResourcesType.Factory.newInstance();
            if (res.isSetBenchmark()) {
                // empty if block
            }
            if (res.isSetCoprocessor()) {
                // empty if block
            }
            if (res.isSetDiskSpaceRequirement()) {
                // empty if block
            }
            if (res.isSetIndividualCPUTime()) {
                jsdlRes.addNewIndividualCPUTime().addNewExact().setDoubleValue(res.getIndividualCPUTime().doubleValue());
            }
            if (res.isSetIndividualPhysicalMemory()) {
                jsdlRes.addNewIndividualPhysicalMemory().addNewExact().setDoubleValue(res.getIndividualPhysicalMemory().doubleValue());
            }
            if (res.isSetIndividualVirtualMemory()) {
                jsdlRes.addNewIndividualVirtualMemory().addNewExact().setDoubleValue(res.getIndividualVirtualMemory().doubleValue());
            }
            if (res.isSetNetworkInfo()) {
                // empty if block
            }
            if (res.isSetNodeAccess()) {
                // empty if block
            }
            if (res.isSetParallelEnvironment()) {
                // empty if block
            }
            if (res.isSetPlatform()) {
                jsdlRes.setCPUArchitecture(this.mapPlatform(res.getPlatform()));
            }
            if (res.isSetQueueName()) {
                // empty if block
            }
            if (res.isSetRemoteSessionAccess()) {
                // empty if block
            }
            if (res.isSetSlotRequirement()) {
                // empty if block
            }
            if (res.isSetTotalCPUTime()) {
                jsdlRes.addNewTotalCPUTime().addNewExact().setDoubleValue(res.getTotalCPUTime().doubleValue());
            }
            if (res.isSetWallTime()) {
                jsdlRes.addNewIndividualCPUTime().addNewExact().setDoubleValue(res.getWallTime().doubleValue());
            }
            this.model.setResources(jsdlRes);
        }
    }

    private CPUArchitectureType mapPlatform(String platform) {
        CPUArchitectureType cpuArch = CPUArchitectureType.Factory.newInstance();
        if (platform.equals("amd64")) {
            cpuArch.setCPUArchitectureName(ProcessorArchitectureEnumeration.X_86_64);
        } else if (platform.equals("itanium")) {
            cpuArch.setCPUArchitectureName(ProcessorArchitectureEnumeration.IA_64);
        } else if (platform.equals("i386")) {
            cpuArch.setCPUArchitectureName(ProcessorArchitectureEnumeration.X_86);
        } else if (platform.equals("powerpc")) {
            cpuArch.setCPUArchitectureName(ProcessorArchitectureEnumeration.POWERPC);
        } else if (platform.equals("sparc")) {
            cpuArch.setCPUArchitectureName(ProcessorArchitectureEnumeration.SPARC);
        } else {
            cpuArch.setCPUArchitectureName(ProcessorArchitectureEnumeration.Enum.forString(platform));
        }
        return cpuArch;
    }

    public String getFormatName() {
        return "emi-adl";
    }
}

