/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.unicore.emi.es.clients.ActivityInfoClient;
import eu.unicore.emi.es.clients.ActivityManagementClient;
import eu.unicore.emi.es.clients.CreateActivityClient;
import eu.unicore.emi.es.clients.DelegationClient;
import eu.unicore.hila.Location;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.emi.es.EmiEsProperties;
import eu.unicore.util.httpclient.ClientProperties;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class EmirSiteDiscovery
implements Callable<List<Site>> {
    private static final Logger log = Logger.getLogger(EmirSiteDiscovery.class);
    private final EMIRClient emirClient;
    private EmiEsProperties props;

    public EmirSiteDiscovery(EMIRClient _client, EmiEsProperties _props) {
        this.emirClient = _client;
        this.props = _props;
    }

    @Override
    public List<Site> call() throws Exception {
        ArrayList<Site> sites = new ArrayList<Site>();
        MultivaluedMapImpl params1 = new MultivaluedMapImpl();
        params1.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), "org.ogf.glue.emies.activitycreation");
        JSONArray createActivityEntries = this.emirClient.queryByQueryParams(params1);
        String serviceId = null;
        for (int i = 0; i < createActivityEntries.length() - 1; ++i) {
            try {
                JSONObject createActivityEntry = createActivityEntries.getJSONObject(i);
                serviceId = createActivityEntry.getString(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName());
                String createActivityServiceUrl = createActivityEntry.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
                MultivaluedMapImpl params2 = new MultivaluedMapImpl();
                params2.add(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), serviceId);
                params2.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), "org.ogf.glue.emies.activitymanagement");
                JSONArray activityMgmtEntries = this.emirClient.queryByQueryParams(params2);
                String amURL = activityMgmtEntries.getJSONObject(0).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
                MultivaluedMapImpl params3 = new MultivaluedMapImpl();
                params3.add(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), serviceId);
                params3.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), "org.ogf.glue.emies.activityinfo");
                JSONArray activityInfoEntries = this.emirClient.queryByQueryParams(params3);
                String aiURL = activityInfoEntries.getJSONObject(0).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
                MultivaluedMapImpl params4 = new MultivaluedMapImpl();
                params4.add(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), serviceId);
                params4.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), "org.ogf.glue.emies.delegation");
                JSONArray delegationEntries = this.emirClient.queryByQueryParams(params4);
                String delegationUrl = null;
                if (delegationEntries.length() > 0) {
                    delegationUrl = delegationEntries.getJSONObject(0).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
                }
                URL siteURL = new URL(createActivityServiceUrl);
                String siteName = siteURL.getHost();
                Location siteLoc = new Location("emi-es:/sites").getChildLocation(siteName);
                ClientProperties sp = new ClientProperties(this.props);
                ActivityInfoClient aiClient = new ActivityInfoClient(aiURL, sp);
                ActivityManagementClient amClient = new ActivityManagementClient(amURL, sp);
                CreateActivityClient caClient = new CreateActivityClient(createActivityServiceUrl, sp);
                DelegationClient delegClient = null;
                try {
                    delegClient = new DelegationClient(delegationUrl, sp);
                }
                catch (NoClassDefFoundError e) {
                    log.warn("Unable to create delegation client for " + serviceId);
                }
                catch (Exception e) {
                    log.warn("Unable to create delegation client for " + serviceId);
                }
                Site site = null;
                site = delegClient != null ? (Site)siteLoc.locate(aiClient, amClient, caClient, delegClient) : (Site)siteLoc.locate(aiClient, amClient, caClient);
                sites.add(site);
                continue;
            }
            catch (Exception e) {
                log.warn("Error assembling site for service ID: " + serviceId, e);
            }
        }
        return sites;
    }
}

