/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import eu.emi.emir.client.EMIRClient;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.emi.es.EmiEsGrid;
import eu.unicore.hila.grid.emi.es.EmiEsProperties;
import eu.unicore.hila.grid.emi.es.EmirSiteDiscovery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

@ResourceType(locationStructure={"emi-es:/sites/?", "emi-es:/{user}@sites/?"})
public class EmiEsSitesCollection
extends BaseResource {
    private static final Logger log = Logger.getLogger(EmiEsSitesCollection.class);

    public EmiEsSitesCollection(Location _location) {
        super(_location);
    }

    @Override
    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> sites = new ArrayList<Resource>();
        EmiEsProperties props = ((EmiEsGrid)EmiEsSitesCollection.findParentLocationOfType(Grid.class, this.location, Grid.class).locate(new Object[0])).getProperties();
        String emirUrl = props.getEmirEndpoint();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 5000L;
        EmirSiteDiscovery siteDiscovery = new EmirSiteDiscovery(new EMIRClient(emirUrl), props);
        Future<List<Site>> sitesFuture = HiLA.getExecutor().submit(siteDiscovery);
        try {
            sites.addAll((Collection)sitesFuture.get(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            log.warn("The retrieval of sites from " + emirUrl + " has been interrupted.");
        }
        catch (ExecutionException e) {
            log.warn("There was an ExecutionException during the retrieval of sites from " + emirUrl + ".", e);
        }
        catch (TimeoutException e) {
            log.warn("The retrieval of sites from " + emirUrl + " timed out.");
        }
        return sites;
    }
}

