/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import eu.emi.es.x2010.x12.adl.ActivityDescriptionDocument;
import eu.emi.es.x2010.x12.adl.DataStagingDocument;
import eu.emi.es.x2010.x12.adl.InputFileDocument;
import eu.emi.es.x2010.x12.adl.SourceDocument;
import eu.emi.es.x2010.x12.creation.ActivityCreationResponseDocument;
import eu.emi.es.x2010.x12.creation.CreateActivityResponseDocument;
import eu.emi.es.x2010.x12.creation.InvalidActivityDescriptionFaultDocument;
import eu.emi.es.x2010.x12.creation.InvalidActivityDescriptionSemanticFaultDocument;
import eu.emi.es.x2010.x12.creation.UnsupportedCapabilityFaultDocument;
import eu.emi.es.x2010.x12.types.AccessControlFaultDocument;
import eu.emi.es.x2010.x12.types.InternalBaseFaultType;
import eu.unicore.emi.es.clients.ActivityInfoClient;
import eu.unicore.emi.es.clients.ActivityManagementClient;
import eu.unicore.emi.es.clients.CreateActivityClient;
import eu.unicore.emi.es.clients.DelegationClient;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.InvalidActivityLimitException;
import eu.unicore.emi.es.faults.InvalidParameterException;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseSite;
import eu.unicore.hila.exceptions.HiLAAccessDeniedException;
import eu.unicore.hila.exceptions.HiLACannotContactSiteException;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.exceptions.HiLANotSupportedException;
import eu.unicore.hila.exceptions.HiLAResourceNotFoundException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Reservation;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.emi.es.EmiEsGrid;
import eu.unicore.hila.grid.emi.es.EmiEsJob;
import eu.unicore.hila.grid.emi.es.EmiEsSitesCollection;
import eu.unicore.hila.grid.resources.ResourceDescription;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.MappingFactory;
import eu.unicore.hila.job.spi.NoSuchMappingException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

@ResourceType(locationStructure={"emi-es:/sites/{siteName}/?", "emi-es:/{user}@sites/{siteName}/?"})
public class EmiEsSite
extends BaseSite {
    private static final Logger log = Logger.getLogger(EmiEsSite.class);
    private ActivityInfoClient actInfoClient = null;
    private ActivityManagementClient actMgmtClient = null;
    private CreateActivityClient creationClient = null;
    private DelegationClient delegationClient = null;
    private String delegationId = null;
    private Calendar delegationExpiry = null;
    private static final Cache sitesCache;
    private static final int DEFAULT_DELEGATION_LIFETIME = 86400000;

    private EmiEsSite(Location _location, Object ... _extraInformation) throws HiLACannotContactSiteException {
        super(_location);
        for (Object object : _extraInformation) {
            if (object instanceof ActivityInfoClient) {
                this.actInfoClient = (ActivityInfoClient)object;
                continue;
            }
            if (object instanceof ActivityManagementClient) {
                this.actMgmtClient = (ActivityManagementClient)object;
                continue;
            }
            if (object instanceof CreateActivityClient) {
                this.creationClient = (CreateActivityClient)object;
                continue;
            }
            if (!(object instanceof DelegationClient)) continue;
            this.delegationClient = (DelegationClient)object;
        }
        String serviceBase = null;
        IClientConfiguration securityProperties = null;
        if (this.actMgmtClient != null) {
            serviceBase = this.getServiceBase(this.actMgmtClient.getURL());
            securityProperties = this.actMgmtClient.getSecurityProperties();
        } else if (this.actInfoClient != null) {
            serviceBase = this.getServiceBase(this.actInfoClient.getURL());
            securityProperties = this.actInfoClient.getSecurityProperties();
        } else if (this.creationClient != null) {
            serviceBase = this.getServiceBase(this.creationClient.getUrl());
            securityProperties = this.creationClient.getSecurityProperties();
        }
        try {
            if (serviceBase != null) {
                if (this.actMgmtClient == null) {
                    this.actMgmtClient = new ActivityManagementClient(serviceBase.concat("ActivityManagementService"), securityProperties);
                }
                if (this.actInfoClient == null) {
                    this.actInfoClient = new ActivityInfoClient(serviceBase.concat("ActivityInfoService"), securityProperties);
                }
                if (this.creationClient == null) {
                    this.creationClient = new CreateActivityClient(serviceBase.concat("CreateActivityService"), securityProperties);
                }
            }
        }
        catch (Exception e) {
            log.error("Error: " + e.getMessage(), e);
        }
        if (this.actInfoClient == null || this.actMgmtClient == null || this.creationClient == null) {
            throw new HiLACannotContactSiteException("Missing service clients.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Site initialized with: " + this.actInfoClient.getURL() + " " + this.actMgmtClient.getURL() + " " + this.creationClient.getUrl());
        }
    }

    private String getServiceBase(String _serviceURL) {
        StringTokenizer tok = new StringTokenizer(_serviceURL, "/");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken());
        }
        List baseTokens = tokens.subList(0, tokens.size() - 2);
        StringBuilder sb = new StringBuilder();
        for (String baseTok : baseTokens) {
            sb.append(baseTok + "/");
        }
        return sb.toString();
    }

    public static final EmiEsSite locate(Location _location, Object ... _extraInformation) throws HiLAException {
        EmiEsSite site;
        Element cacheElement = sitesCache.get(_location);
        if (cacheElement != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found cache entry for " + _location);
            }
            if ((site = (EmiEsSite)cacheElement.getObjectValue()).ok()) {
                return site;
            }
            sitesCache.removeElement(cacheElement);
        }
        if (log.isDebugEnabled()) {
            log.debug("Cache for " + _location + " was invalid.");
        }
        if (_extraInformation.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new Site object for " + _location);
                if (log.isTraceEnabled()) {
                    for (Object object : _extraInformation) {
                        log.trace("Using extraInformation " + object);
                    }
                }
            }
            site = new EmiEsSite(_location, _extraInformation);
            sitesCache.put(new Element(_location, site));
            return site;
        }
        Location sitesLoc = EmiEsSite.findParentLocationOfType(EmiEsSitesCollection.class, _location, EmiEsGrid.class);
        for (Resource res : sitesLoc.locate(new Object[0]).getChildren()) {
            if (!res.getLocation().equals(_location)) continue;
            return (EmiEsSite)res;
        }
        throw new HiLAResourceNotFoundException("Site " + _location + " cannot be found.");
    }

    @Override
    public Storage getStorage(String _storageName) throws HiLAException {
        throw new HiLANotImplementedException("Site storages not available in EMI-ES.");
    }

    @Override
    public Job submit(JobModel _jd) throws HiLAException {
        try {
            CreateActivityResponseDocument card;
            ActivityDescriptionDocument ad = (ActivityDescriptionDocument)MappingFactory.getMapping("emi-adl").createModelToNativeMapping(_jd).getNative();
            this.addDelegationIfNecessary(ad);
            if (log.isTraceEnabled()) {
                log.trace("ActivityDescription after adding delegationId: " + ad.xmlText(new XmlOptions().setSavePrettyPrint()));
            }
            if ((card = this.creationClient.createActivities(ad.getActivityDescription())).getCreateActivityResponse().getActivityCreationResponseArray().length == 1) {
                ActivityCreationResponseDocument.ActivityCreationResponse acResp = card.getCreateActivityResponse().getActivityCreationResponseArray(0);
                if (acResp.isSetAccessControlFault()) {
                    AccessControlFaultDocument.AccessControlFault acFault = acResp.getAccessControlFault();
                    throw new HiLAAccessDeniedException(acFault.getMessage() + ", " + acFault.getFailureCode());
                }
                if (acResp.isSetInternalBaseFault()) {
                    InternalBaseFaultType baseFault = acResp.getInternalBaseFault();
                    throw new HiLAException(baseFault.getMessage() + ", " + baseFault.getFailureCode());
                }
                if (acResp.isSetInvalidActivityDescriptionFault()) {
                    InvalidActivityDescriptionFaultDocument.InvalidActivityDescriptionFault invalidDescription = acResp.getInvalidActivityDescriptionFault();
                    throw new HiLAException(invalidDescription.getMessage() + ", " + invalidDescription.getFailureCode());
                }
                if (acResp.isSetInvalidActivityDescriptionSemanticFault()) {
                    InvalidActivityDescriptionSemanticFaultDocument.InvalidActivityDescriptionSemanticFault invalidSemantic = acResp.getInvalidActivityDescriptionSemanticFault();
                    throw new HiLAException(invalidSemantic.getMessage() + ", " + invalidSemantic.getFailureCode());
                }
                if (acResp.isSetUnsupportedCapabilityFault()) {
                    UnsupportedCapabilityFaultDocument.UnsupportedCapabilityFault unsuppCap = acResp.getUnsupportedCapabilityFault();
                    throw new HiLAException(unsuppCap.getMessage() + " (" + unsuppCap.getFailureCode() + ")");
                }
                String aid = card.getCreateActivityResponse().getActivityCreationResponseArray(0).getActivityID();
                Location actLoc = this.getLocation().getChildLocation("tasks").getChildLocation(aid);
                return new EmiEsJob(actLoc, this.actInfoClient, this.actMgmtClient);
            }
            throw new HiLAException("Invalid response on submit.");
        }
        catch (NoSuchMappingException e) {
            throw new HiLAException("Unable to find mapping for JobModel to EMI ActivityDescription.", e);
        }
        catch (Exception e) {
            throw new HiLAException("Error submitting job.", e);
        }
    }

    private void addDelegationIfNecessary(ActivityDescriptionDocument ad) {
        this.createOrUpdateDelegation();
        if (this.delegationId == null) {
            return;
        }
        if (ad.getActivityDescription().isSetDataStaging()) {
            DataStagingDocument.DataStaging ds = ad.getActivityDescription().getDataStaging();
            for (InputFileDocument.InputFile inputFile : ds.getInputFileArray()) {
                for (SourceDocument.Source source : inputFile.getSourceArray()) {
                    source.setDelegationID(this.delegationId);
                }
            }
            for (XmlObject xmlObject : ds.getOutputFileArray()) {
                for (XmlObject xmlObject2 : xmlObject.getTargetArray()) {
                    xmlObject2.setDelegationID(this.delegationId);
                }
            }
        }
    }

    private synchronized void createOrUpdateDelegation() {
        Calendar currentPlusHalfDelegTime = Calendar.getInstance();
        currentPlusHalfDelegTime.add(14, 43200000);
        if (this.delegationId == null) {
            this.updateDelegation();
        } else if (currentPlusHalfDelegTime.after(this.delegationExpiry)) {
            this.updateDelegation();
        }
    }

    private void updateDelegation() {
        try {
            this.delegationId = this.delegationClient.issueDelegation(86400000L);
            Calendar calExpiry = Calendar.getInstance();
            calExpiry.add(14, 86400000);
            this.delegationExpiry = calExpiry;
        }
        catch (Exception e) {
            if (this.delegationId != null) {
                log.error("Failed to update delegation. Continuing with existing id: " + this.delegationId, e);
            }
            log.error("Failed to update delegation. Continuingn without one.", e);
        }
    }

    @Override
    public List<Job> getTasks() throws HiLAException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        try {
            List<String> actIds = this.actInfoClient.listActivities();
            for (String id : actIds) {
                Location jobLocation = this.getLocation().getChildLocation("tasks").getChildLocation(id);
                jobs.add((Job)jobLocation.locate(this.actInfoClient, this.actMgmtClient, this.creationClient));
            }
        }
        catch (InternalBaseFault e) {
            log.error("CHANGE ME: bogus error message", e);
        }
        catch (InvalidActivityLimitException e) {
            log.error("CHANGE ME: bogus error message", e);
        }
        catch (InvalidParameterException e) {
            log.error("CHANGE ME: bogus error message", e);
        }
        catch (AccessControlFault e) {
            log.error("CHANGE ME: bogus error message", e);
        }
        catch (VectorLimitExceededFault e) {
            log.error("CHANGE ME: bogus error message", e);
        }
        return jobs;
    }

    @Override
    public Job getTask(String _taskId) throws HiLAException {
        try {
            this.actMgmtClient.getActivityStatus(_taskId);
            Location jobLocation = this.getLocation().getChildLocation("tasks").getChildLocation(_taskId);
            return (Job)jobLocation.locate(this.actMgmtClient);
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("", e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("", e);
        }
        catch (AccessControlFault e) {
            throw new HiLAAccessDeniedException("Cannot access activity " + _taskId + ": " + e.getMessage());
        }
    }

    @Override
    public Reservation reserve(ResourceDescription _rd, Calendar _startTime) throws HiLAException {
        throw new HiLANotSupportedException("EMI ES implementation does not support reservations.");
    }

    @Override
    public List<Reservation> getReservations() throws HiLAException {
        throw new HiLANotSupportedException("EMI ES implementation does not support reservations.");
    }

    @Override
    public Reservation getReservation(String name) throws HiLAException {
        throw new HiLANotSupportedException("EMI ES implementation does not support reservations.");
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        manager.addCache(new Cache(EmiEsSite.class.getName(), 500, true, true, 0L, 0L));
        sitesCache = manager.getCache(EmiEsSite.class.getName());
    }
}

