/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import eu.emi.es.x2010.x12.activity.ActivityInfoItemDocument;
import eu.emi.es.x2010.x12.activity.ActivityStatusItemDocument;
import eu.emi.es.x2010.x12.types.ActivityStatusAttribute;
import eu.emi.es.x2010.x12.types.ActivityStatusDocument;
import eu.unicore.emi.es.clients.ActivityInfoClient;
import eu.unicore.emi.es.clients.ActivityManagementClient;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.UnknownAttributeException;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseJob;
import eu.unicore.hila.exceptions.HiLAAccessDeniedException;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

@ResourceType(locationStructure={"emi-es:/sites/{siteName}/tasks/{taskId}/?", "emi-es:/{user}@sites/{siteName}/tasks/{taskId}/?"})
public class EmiEsJob
extends BaseJob {
    private static final Logger log = Logger.getLogger(EmiEsJob.class);
    private ActivityManagementClient actMgmtClient = null;
    private ActivityInfoClient actInfoClient = null;
    private static final Cache tasksCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmiEsJob(Location location, Object ... _extraInformation) throws HiLAFactoryException {
        super(location);
        for (Object object : _extraInformation) {
            if (object instanceof ActivityManagementClient) {
                this.actMgmtClient = (ActivityManagementClient)object;
                continue;
            }
            if (!(object instanceof ActivityInfoClient)) continue;
            this.actInfoClient = (ActivityInfoClient)object;
        }
        if (this.actMgmtClient == null || this.actInfoClient == null) {
            throw new HiLAFactoryException("Unable to create job object.");
        }
        this.setCurrentState(TaskStatus.NEW);
        Cache cache = tasksCache;
        synchronized (cache) {
            tasksCache.put(new Element(location, this));
        }
    }

    public static final Resource locate(Location _location, Object ... _extraInformation) throws HiLAException {
        Element cacheElem;
        if (tasksCache.isKeyInCache(_location) && (cacheElem = tasksCache.get(_location)) != null) {
            return (Resource)cacheElem.getObjectValue();
        }
        return new EmiEsJob(_location, _extraInformation);
    }

    @Override
    public void startASync(java.io.File ... imports) throws HiLAException {
        try {
            this.actMgmtClient.dataPushDone(this.getId());
        }
        catch (Exception e) {
            throw new HiLAException("Unable to signal data push done.", e);
        }
    }

    @Override
    public List<SimpleTransfer> cleanup(File ... exports) throws HiLAException {
        try {
            this.actMgmtClient.wipeActivity(this.getName());
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to wipe activity " + this.getName(), e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Unable to wipe activity " + this.getName(), e);
        }
        catch (AccessControlFault e) {
            throw new HiLAException("Unable to wipe activity " + this.getName(), e);
        }
        return Collections.emptyList();
    }

    @Override
    public int getExitCode() throws HiLAException {
        try {
            return this.actMgmtClient.getActivityInfo(this.getId()).get(0).getActivityInfoDocument().getExitCode();
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to retrieve exit code of activity " + this.getId(), e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Unable to retrieve exit code of activity " + this.getId(), e);
        }
        catch (UnknownAttributeException e) {
            throw new HiLAException("Unable to retrieve exit code of activity " + this.getId(), e);
        }
    }

    @Override
    public String getLog() throws HiLAException {
        try {
            List<ActivityInfoItemDocument.ActivityInfoItem> actInfo = this.actMgmtClient.getActivityInfo(this.getId());
            if (actInfo.size() != 1) {
                throw new HiLAException("Expected exactly one information item, got " + actInfo.size());
            }
            return actInfo.get(0).getActivityInfoDocument().getLogDir();
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to retrieve job log.", e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Requested too many jobs' information", e);
        }
        catch (UnknownAttributeException e) {
            throw new HiLAException("Unknown activity.", e);
        }
    }

    @Override
    public Metadata getMetadata() throws HiLAException {
        Metadata md = new Metadata();
        try {
            List<ActivityInfoItemDocument.ActivityInfoItem> ainfos = this.actMgmtClient.getActivityInfo(this.getId());
            if (ainfos.size() > 0) {
                ActivityInfoItemDocument.ActivityInfoItem ainfo = ainfos.get(0);
                ActivityInfoItemDocument aid = ActivityInfoItemDocument.Factory.newInstance();
                aid.setActivityInfoItem(ainfo);
                md.setData("activityInfo", aid.xmlText());
                return md;
            }
            throw new HiLAException("Unable to retrieve activity info. Empty list from server.");
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to retrieve activity info.", e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Unable to retrieve activity info.", e);
        }
        catch (UnknownAttributeException e) {
            throw new HiLAException("Unable to retrieve activity info.", e);
        }
    }

    @Override
    public File getStdErr() throws HiLAException {
        try {
            ActivityInfoItemDocument.ActivityInfoItem aInfo = this.actMgmtClient.getActivityInfo(this.getId()).get(0);
            String stdErrName = aInfo.getActivityInfoDocument().getStdErr();
            return (File)this.getOutputDir(aInfo).getChild(stdErrName == null ? "stderr" : stdErrName);
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to get standard out for job " + this.getLocation(), e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Unable to get standard out for job " + this.getLocation(), e);
        }
        catch (UnknownAttributeException e) {
            throw new HiLAException("Unable to get standard out for job " + this.getLocation(), e);
        }
        catch (Exception e) {
            throw new HiLAException("Unable to get standard out for job " + this.getLocation());
        }
    }

    @Override
    public File getStdOut() throws HiLAException {
        try {
            ActivityInfoItemDocument.ActivityInfoItem aInfo = this.actMgmtClient.getActivityInfo(this.getId()).get(0);
            String stdOutName = aInfo.getActivityInfoDocument().getStdOut();
            return (File)this.getOutputDir(aInfo).getChild(stdOutName == null ? "stdout" : stdOutName);
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to get standard out for job " + this.getLocation(), e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Unable to get standard out for job " + this.getLocation(), e);
        }
        catch (UnknownAttributeException e) {
            throw new HiLAException("Unable to get standard out for job " + this.getLocation(), e);
        }
    }

    private File getSessionDir(ActivityInfoItemDocument.ActivityInfoItem aInfo) throws HiLAException {
        String[] sessDirUrl = aInfo.getActivityInfoDocument().getSessionDirectoryArray();
        for (int i = 0; i < sessDirUrl.length; ++i) {
            try {
                return (File)new Location(sessDirUrl[i]).locate(this.actInfoClient.getSecurityProperties());
            }
            catch (HiLAException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("No implementation of " + File.class.getName() + " for " + sessDirUrl[i]);
                continue;
            }
        }
        throw new HiLAException("Cannot find usable protocol for session directory.");
    }

    private File getOutputDir(ActivityInfoItemDocument.ActivityInfoItem _aInfo) throws HiLAException {
        String[] outputDirUrls;
        for (String outputDirUrl : outputDirUrls = _aInfo.getActivityInfoDocument().getStageOutDirectoryArray()) {
            try {
                return (File)new Location(outputDirUrl).locate(this.actInfoClient.getSecurityProperties());
            }
            catch (HiLAException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("No implementation of " + File.class.getName() + " for " + outputDirUrl);
            }
        }
        throw new HiLAException("Cannot find usable protocol for output directory.");
    }

    @Override
    public File getWorkingDirectory() throws HiLAException {
        ActivityInfoItemDocument.ActivityInfoItem aInfo;
        try {
            aInfo = this.actMgmtClient.getActivityInfo(this.getId()).get(0);
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to get properties for job " + this.getLocation(), e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Unable to get properties for job " + this.getLocation(), e);
        }
        catch (UnknownAttributeException e) {
            throw new HiLAException("Unable to get properties for job " + this.getLocation(), e);
        }
        return this.getSessionDir(aInfo);
    }

    @Override
    public void abort() throws HiLAException {
        try {
            this.actMgmtClient.cancelActivity(this.getId());
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("Unable to abort job.", e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("Unable to abort job.", e);
        }
        catch (AccessControlFault e) {
            throw new HiLAException("Unable to abort job.", e);
        }
    }

    @Override
    public String getId() throws HiLAException {
        return this.getName();
    }

    @Override
    public TaskStatus status() throws HiLAException {
        if (super.status().isFinalState()) {
            return super.status();
        }
        return this.updateStatus();
    }

    private TaskStatus updateStatus() throws HiLAException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Updating status of " + this.location);
            }
            List<ActivityStatusItemDocument.ActivityStatusItem> actStatusResp = this.actMgmtClient.getActivityStatus(this.getId());
            TaskStatus newStatus = this.mapStatus(actStatusResp.get(0).getActivityStatus());
            this.setCurrentState(newStatus);
            return newStatus;
        }
        catch (InternalBaseFault e) {
            throw new HiLAException("", e);
        }
        catch (VectorLimitExceededFault e) {
            throw new HiLAException("", e);
        }
        catch (AccessControlFault e) {
            throw new HiLAAccessDeniedException(e.getMessage(), e);
        }
        catch (HiLAException e) {
            throw new HiLAException("Unable to determine job id.", e);
        }
    }

    private TaskStatus mapStatus(ActivityStatusDocument.ActivityStatus activityStatus) throws HiLAException {
        switch (activityStatus.getStatus().intValue()) {
            case 1: {
                return TaskStatus.NEW;
            }
            case 3: 
            case 6: 
            case 7: {
                return TaskStatus.RUNNING;
            }
            case 2: 
            case 4: 
            case 5: {
                return TaskStatus.PENDING;
            }
            case 8: {
                for (ActivityStatusAttribute.Enum attribute : activityStatus.getAttributeArray()) {
                    switch (attribute.intValue()) {
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: {
                            return TaskStatus.FAILED;
                        }
                        case 12: 
                        case 13: 
                        case 14: {
                            return TaskStatus.ABORTED;
                        }
                    }
                }
                return TaskStatus.SUCCESSFUL;
            }
        }
        throw new HiLAException("Cannot map status " + activityStatus.getStatus().toString() + " to any known HiLA status.");
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        manager.addCache(new Cache(EmiEsJob.class.getName(), 10000, true, true, 0L, 0L));
        tasksCache = manager.getCache(EmiEsJob.class.getName());
    }
}

