/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import eu.unicore.hila.Location;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseGrid;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.emi.es.EmiEsProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.log4j.Logger;

@ResourceType(locationStructure={"emi-es:/"})
public class EmiEsGrid
extends BaseGrid {
    private static final Logger log = Logger.getLogger(EmiEsGrid.class);
    private static final String CONFIG_KEY = "hila.emi.es.config";
    private final EmiEsProperties properties = new EmiEsProperties();
    private Object configLock = new Object();
    private Config config = null;

    private EmiEsGrid(Location _location, Object[] _extraInformation) throws HiLAException {
        super(_location);
        this.initialize();
    }

    public static final EmiEsGrid locate(Location _location, Object ... _extraInformation) throws HiLAException {
        return new EmiEsGrid(_location, _extraInformation);
    }

    public EmiEsProperties getProperties() {
        return this.properties;
    }

    private void initialize() throws HiLAException {
        InputStream configIS = null;
        try {
            String config = System.getProperty(CONFIG_KEY);
            if (config != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using EMI ES configuration as defined by system property hila.emi.es.config: " + config);
                }
                File configFile = new File(config);
                configIS = new FileInputStream(configFile);
                this.properties.load(configIS);
                this.properties.setConfigBase(configFile.getParentFile().getAbsoluteFile());
                return;
            }
        }
        catch (FileNotFoundException e) {
            throw new HiLAFactoryException("Cannot find configuration file.", e);
        }
        catch (IOException e) {
            throw new HiLAFactoryException("Cannot open configuration file.", e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream.", e);
                }
            }
        }
        try {
            File configFile = new File("emi-es.properties");
            configIS = new FileInputStream(configFile);
            this.properties.load(configIS);
            this.properties.setConfigBase(configFile.getParentFile().getAbsoluteFile());
            return;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new HiLAException("Cannot read configuration file emi-es.properties from current directory.", e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream", e);
                }
            }
        }
        try {
            File configFile = new File(System.getProperty("user.home") + File.separator + ".hila2" + File.separator + "emi-es.properties");
            configIS = new FileInputStream(configFile);
            this.properties.load(configIS);
            this.properties.setConfigBase(configFile.getParentFile().getAbsoluteFile());
            return;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new HiLAException("Cannot read configuration file emi-es.properties from ~/.hila2.", e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream", e);
                }
            }
        }
        try {
            configIS = this.getClass().getResourceAsStream("/emi-es.properties");
            if (configIS == null) {
                throw new HiLAFactoryException("Unable to find useable EMI ES configuration.");
            }
            this.properties.load(configIS);
        }
        catch (IOException e) {
            throw new HiLAFactoryException("Unable to read emi-es.properties from classpath", e);
        }
        finally {
            if (configIS != null) {
                try {
                    configIS.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close config file input stream", e);
                }
            }
        }
        if (log.isTraceEnabled()) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                log.trace(entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config getConfig() {
        Object object = this.configLock;
        synchronized (object) {
            if (this.config == null) {
                this.config = this.properties.getConfig();
            }
        }
        return this.config;
    }
}

