/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.clients;

import eu.emi.es.x2010.x12.resourceinfo.DefaultQueryDialectsEnumType;
import eu.emi.es.x2010.x12.resourceinfo.GetResourceInfoDocument;
import eu.emi.es.x2010.x12.resourceinfo.GetResourceInfoResponseDocument;
import eu.emi.es.x2010.x12.resourceinfo.QueryExpressionType;
import eu.emi.es.x2010.x12.resourceinfo.QueryResourceInfoDocument;
import eu.emi.es.x2010.x12.resourceinfo.QueryResourceInfoResponseDocument;
import eu.unicore.emi.es.ResourceInfoService;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.InternalResourceInfoException;
import eu.unicore.emi.es.faults.NotSupportedQueryDialectException;
import eu.unicore.emi.es.faults.NotValidQueryStatementException;
import eu.unicore.emi.es.faults.ResourceInfoNotFoundException;
import eu.unicore.emi.es.faults.UnknownQueryException;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.xmlbeans.XmlString;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingEndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.EndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;

public class ResourceInfoClient {
    public static final String SERVICE_NAME = "ResourceInfoService";
    public static final String SERVICE_PATH = "/ResourceInfoService";
    final ResourceInfoService ris;
    private final String url;
    private final IClientConfiguration sp;

    public ResourceInfoClient(String _url, IClientConfiguration _sp) throws MalformedURLException {
        this.url = _url;
        this.sp = _sp;
        this.ris = new UnicoreXFireClientFactory(_sp).createPlainWSProxy(ResourceInfoService.class, _url);
    }

    public List<String> getQueryDialects() throws InternalResourceInfoException, AccessControlFault, ResourceInfoNotFoundException, InternalBaseFault {
        ServiceT[] serviceArray;
        ComputingServiceT[] computingServiceArray;
        HashSet<String> dialects = new HashSet<String>();
        GetResourceInfoResponseDocument.GetResourceInfoResponse resourceInfoResponse = this.getResourceInfo().getGetResourceInfoResponse();
        for (ComputingServiceT cs : computingServiceArray = resourceInfoResponse.getServices().getComputingServiceArray()) {
            ComputingEndpointT[] ces;
            for (ComputingEndpointT computingEndpointT : ces = cs.getComputingEndpointArray()) {
                for (String cap : computingEndpointT.getCapabilityArray()) {
                    dialects.add(cap);
                }
            }
        }
        for (ServiceT s : serviceArray = resourceInfoResponse.getServices().getServiceArray()) {
            EndpointT[] ses;
            for (EndpointT endpointT : ses = s.getEndpointArray()) {
                for (String cap : endpointT.getCapabilityArray()) {
                    dialects.add(cap);
                }
            }
        }
        return Collections.list(Collections.enumeration(dialects));
    }

    public GetResourceInfoResponseDocument getResourceInfo() throws InternalResourceInfoException, AccessControlFault, ResourceInfoNotFoundException, InternalBaseFault {
        GetResourceInfoDocument request = GetResourceInfoDocument.Factory.newInstance();
        request.addNewGetResourceInfo();
        return this.ris.GetResourceInfo(request);
    }

    public QueryResourceInfoResponseDocument queryResourceInfo(String query) throws AccessControlFault, NotValidQueryStatementException, InternalBaseFault, NotSupportedQueryDialectException, UnknownQueryException {
        return this.queryResourceInfo(DefaultQueryDialectsEnumType.XPATH_1_0.toString(), query);
    }

    public QueryResourceInfoResponseDocument queryResourceInfo(String dialect, String query) throws AccessControlFault, NotValidQueryStatementException, InternalBaseFault, NotSupportedQueryDialectException, UnknownQueryException {
        QueryResourceInfoDocument doc = QueryResourceInfoDocument.Factory.newInstance();
        QueryResourceInfoDocument.QueryResourceInfo q = doc.addNewQueryResourceInfo();
        q.setQueryDialect(dialect);
        QueryExpressionType exp = q.addNewQueryExpression();
        XmlString queryX = XmlString.Factory.newInstance();
        queryX.setStringValue(query);
        exp.set(queryX);
        return this.queryResourceInfo(doc);
    }

    public QueryResourceInfoResponseDocument queryResourceInfo(QueryResourceInfoDocument expression) throws AccessControlFault, NotValidQueryStatementException, InternalBaseFault, NotSupportedQueryDialectException, UnknownQueryException {
        return this.ris.QueryResourceInfo(expression);
    }

    public String getUrl() {
        return this.url;
    }

    public IClientConfiguration getSecurityProperties() {
        return this.sp;
    }
}

