/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.clients;

import eu.unicore.emi.es.DelegationService;
import eu.unicore.emi.es.faults.DelegationServiceException;
import eu.unicore.emi.es.utils.ProxyGenerator;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.io.pem.PemReader;
import org.gridsite.namespaces.delegation2.DestroyDocument;
import org.gridsite.namespaces.delegation2.GetNewProxyReqDocument;
import org.gridsite.namespaces.delegation2.GetNewProxyReqResponseDocument;
import org.gridsite.namespaces.delegation2.PutProxyDocument;

public class DelegationClient {
    private final DelegationService delService;
    private final IClientConfiguration securityProperties;

    public DelegationClient(String endpointUrl, IClientConfiguration sec) throws Exception {
        this.delService = new UnicoreXFireClientFactory(sec).createPlainWSProxy(DelegationService.class, endpointUrl);
        this.securityProperties = sec;
    }

    public String issueDelegation(long lifetime) throws Exception {
        GetNewProxyReqResponseDocument initDelegationResponse = this.initDelegation();
        String base64 = initDelegationResponse.getGetNewProxyReqResponse().getProxyRequest();
        String delegationID = initDelegationResponse.getGetNewProxyReqResponse().getDelegationID();
        if (delegationID == null) {
            throw new Exception("The server did not send back a delegation id!");
        }
        if (base64 == null) {
            throw new Exception("The server did not send back a certificate signing request!");
        }
        PemReader pr = new PemReader(new StringReader(base64));
        byte[] csrDerEncode = pr.readPemObject().getContent();
        pr.close();
        PKCS10CertificationRequest csr = new PKCS10CertificationRequest(csrDerEncode);
        X509Certificate x509cert = ProxyGenerator.getSignedCertificate(csr, (int)lifetime, this.securityProperties.getCredential().getCertificateChain()[0], this.securityProperties.getCredential().getKey());
        this.putDelegation(delegationID, x509cert);
        return delegationID;
    }

    public GetNewProxyReqResponseDocument initDelegation() throws DelegationServiceException {
        GetNewProxyReqDocument ini_req = GetNewProxyReqDocument.Factory.newInstance();
        ini_req.addNewGetNewProxyReq();
        return this.delService.getNewProxyReq(ini_req);
    }

    public void putDelegation(String delegationID, Certificate proxyCert) throws DelegationServiceException {
        PutProxyDocument request = PutProxyDocument.Factory.newInstance();
        request.addNewPutProxy().setDelegationID(delegationID);
        try {
            StringWriter s = new StringWriter();
            PEMWriter pw = new PEMWriter(s);
            pw.writeObject(proxyCert);
            for (X509Certificate chainCert : this.securityProperties.getCredential().getCertificateChain()) {
                pw.writeObject(chainCert);
            }
            pw.close();
            request.getPutProxy().setProxy(s.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to encode certificate.", e);
        }
        this.delService.putProxy(request);
    }

    public void destroyDelegation(String delegationID) throws DelegationServiceException {
        DestroyDocument req = DestroyDocument.Factory.newInstance();
        req.addNewDestroy().setDelegationID(delegationID);
        this.delService.destroy(req);
    }
}

