/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.clients;

import eu.emi.es.x2010.x12.adl.ActivityDescriptionDocument;
import eu.emi.es.x2010.x12.creation.CreateActivityDocument;
import eu.emi.es.x2010.x12.creation.CreateActivityResponseDocument;
import eu.unicore.emi.es.CreateActivityService;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;

public class CreateActivityClient {
    public static final String SERVICE_NAME = "CreateActivityService";
    public static final String SERVICE_PATH = "/CreateActivityService";
    private final String url;
    private final IClientConfiguration securityProperties;
    private final CreateActivityService activityService;

    public CreateActivityClient(String endpointUrl, IClientConfiguration sec) throws Exception {
        this.url = endpointUrl;
        this.securityProperties = sec;
        this.activityService = new UnicoreXFireClientFactory(sec).createPlainWSProxy(CreateActivityService.class, endpointUrl);
    }

    public CreateActivityResponseDocument createActivities(ActivityDescriptionDocument.ActivityDescription ... emiJob) throws VectorLimitExceededFault, InternalBaseFault {
        CreateActivityDocument activity_request = CreateActivityDocument.Factory.newInstance();
        if (emiJob != null && emiJob.length > 0) {
            CreateActivityDocument.CreateActivity ca = activity_request.addNewCreateActivity();
            for (ActivityDescriptionDocument.ActivityDescription activityDescription : emiJob) {
                ca.addNewActivityDescription().set(activityDescription);
            }
        }
        return this.activityService.CreateActivity(activity_request);
    }

    public String getUrl() {
        return this.url;
    }

    public IClientConfiguration getSecurityProperties() {
        return this.securityProperties;
    }
}

