/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class ProxyACExtension
extends ASN1Encodable {
    public static final String AC_OID = "1.3.6.1.4.1.8005.100.100.5";
    private DERSequence ac = null;

    public ProxyACExtension(byte[] bytes) throws IOException {
        this.ac = (DERSequence)ASN1Object.fromByteArray(bytes);
    }

    public ProxyACExtension(AttributeCertificate[] certificates) {
        DERSequence seqWrapper;
        DERSequence seqac = new DERSequence(certificates);
        this.ac = seqWrapper = new DERSequence(seqac);
    }

    public static ProxyACExtension getInstance(X509Certificate cert) throws IOException {
        byte[] bytes = CertificateHelpers.getExtensionBytes(cert, AC_OID);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ProxyACExtension(bytes);
    }

    public AttributeCertificate[] getAttributeCertificates() {
        DERSequence seqac = (DERSequence)this.ac.getObjectAt(0);
        AttributeCertificate[] ret = new AttributeCertificate[seqac.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = AttributeCertificate.getInstance(seqac.getObjectAt(i));
        }
        return ret;
    }

    @Override
    public DERObject toASN1Object() {
        return this.ac;
    }
}

