/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.wsn.util;

import de.fzj.unicore.wsrflite.xmlbeans.wsn.Topic;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSNConstants;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSNTopicExpression;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.WSNTopicExpressionType;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlQName;
import org.oasisOpen.docs.wsn.b2.TopicDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionType;
import org.oasisOpen.docs.wsn.t1.SimpleTopicExpression;

public class SimpleWSNTopicExpression
implements WSNConstants,
WSNTopicExpression,
WSNTopicExpressionType {
    private QName qn;

    public SimpleWSNTopicExpression() {
    }

    public SimpleWSNTopicExpression(QName qn) {
        this.qn = qn;
    }

    @Override
    public TopicExpressionDocument toXml() {
        TopicExpressionDocument td = TopicExpressionDocument.Factory.newInstance();
        TopicExpressionType t = td.addNewTopicExpression();
        SimpleTopicExpression ste = SimpleTopicExpression.Factory.newInstance();
        ste.setQNameValue(this.qn);
        t.set(ste);
        t.setDialect(this.getDialect());
        return td;
    }

    public static QName extractQName(TopicExpressionType t) {
        try {
            XmlQName xq = XmlQName.Factory.parse(t.xmlText());
            return xq.getQNameValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public WSNTopicExpression fromXml(TopicExpressionType type) {
        return new SimpleWSNTopicExpression(SimpleWSNTopicExpression.extractQName(type));
    }

    @Override
    public boolean matches(Topic topic) {
        return this.qn.equals(topic.getQName());
    }

    @Override
    public String getDialect() {
        return "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qn == null ? 0 : this.qn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleWSNTopicExpression)) {
            return false;
        }
        SimpleWSNTopicExpression other = (SimpleWSNTopicExpression)obj;
        return !(this.qn == null ? other.qn != null : !this.qn.equals(other.qn));
    }

    public TopicDocument getTopicDocument() {
        TopicDocument td = TopicDocument.Factory.newInstance();
        td.setTopic(this.toXml().getTopicExpression());
        return td;
    }
}

