/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.MultiInvocationHandler;
import eu.unicore.security.xfireutil.client.ReliableProxy;
import eu.unicore.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiWSRFClient<T extends BaseWSRFClient> {
    protected static final Logger logger = Log.getLogger("unicore.client", MultiWSRFClient.class);
    public static final int MULTICAST = 1;
    public static final int ROUNDROBIN = 2;
    public static final int ROUNDROBIN_RETRY_ON_FAILURE = 3;
    public static final int PRIMARY_WITH_BACKUP = 4;
    protected List<T> clients = new ArrayList<T>();
    private int mode = 1;
    private int maxRetries = 10;
    private boolean errorsOccurred;

    public void addClient(T client) {
        this.clients.add(client);
    }

    public boolean removeClient(T client) {
        return this.clients.remove(client);
    }

    public void setGlobalRetryPolicy(ReliableProxy.RetryDecider policy) {
        for (BaseWSRFClient c : this.clients) {
            c.setRetryHandler(policy);
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public <Target> Target makeProxy(Class<Target> target) throws Exception {
        ArrayList<Target> proxies = new ArrayList<Target>();
        for (BaseWSRFClient client : this.clients) {
            proxies.add(client.makeProxy(target));
        }
        InvocationHandler h = this.getInvocationHandler(proxies);
        Object proxy = Proxy.newProxyInstance(target.getClassLoader(), new Class[]{target}, h);
        return (Target)proxy;
    }

    protected <Target> InvocationHandler getInvocationHandler(List<Target> targets) {
        MultiInvocationHandler<Target> h = new MultiInvocationHandler<Target>(this);
        h.setMode(this.mode);
        h.setTargets(targets);
        return h;
    }

    protected int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    void setErrorsOccurred(boolean errors) {
        this.errorsOccurred = errors;
    }

    public boolean getErrorsOccurred() {
        return this.errorsOccurred;
    }
}

