/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.ByteIOBaseClient;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.uas.fts.byteio.ByteIO;
import de.fzj.unicore.uas.fts.byteio.RandomByteIO;
import de.fzj.unicore.wsrflite.xfire.MTOMInHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.ggf.schemas.byteio.x2005.x10.byteIo.TransferInformationType;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.AppendDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.AppendResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.ReadResponseDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.TruncAppendDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteDocument;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.WriteResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RByteIOClient
extends ByteIOBaseClient {
    private static final Logger logger = Log.getLogger("unicore.client", RByteIOClient.class);
    private final RandomByteIO fts = this.makeProxy(RandomByteIO.class);

    public RByteIOClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public RByteIOClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public byte[] read(long offset, long numBlocks, long bytesPerBlock, long stride) throws Exception {
        ReadDocument req = ReadDocument.Factory.newInstance();
        ReadDocument.Read r = req.addNewRead();
        r.setNumBlocks(numBlocks);
        r.setBytesPerBlock(bytesPerBlock);
        r.setStartOffset(BigInteger.valueOf(offset));
        r.setStride(stride);
        String mechanism = this.isMTOMEnabled() ? "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom" : "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple";
        r.addNewTransferInformation().setTransferMechanism(mechanism);
        ReadResponseDocument res = this.fts.read(req);
        byte[] data = null;
        data = this.isMTOMEnabled() ? MTOMInHandler.getAttachment() : ByteIO.decode("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple", res.getReadResponse().getTransferInformation());
        return data;
    }

    public void write(byte[] data) throws Exception {
        this.write(data, 0L, 1L, data.length, 0L);
    }

    public void truncAppend(long offset, byte[] data) throws Exception {
        TruncAppendDocument req = TruncAppendDocument.Factory.newInstance();
        TruncAppendDocument.TruncAppend ta = req.addNewTruncAppend();
        ta.setOffset(BigInteger.valueOf(offset));
        TransferInformationType ti = ta.addNewTransferInformation();
        String mechanism = this.isMTOMEnabled() ? "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom" : "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple";
        ti.set(ByteIO.encode(mechanism, data));
        ti.setTransferMechanism(mechanism);
        this.fts.truncAppend(req);
    }

    public WriteResponseDocument write(byte[] data, long offset, long numBlocks, long bytesPerBlock, long stride) throws Exception {
        WriteDocument req = WriteDocument.Factory.newInstance();
        WriteDocument.Write r = req.addNewWrite();
        TransferInformationType ti = r.addNewTransferInformation();
        String mechanism = this.isMTOMEnabled() ? "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom" : "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple";
        ti.set(ByteIO.encode(mechanism, data));
        ti.setTransferMechanism(mechanism);
        r.setBytesPerBlock(bytesPerBlock);
        r.setStartOffset(BigInteger.valueOf(offset));
        r.setStride(stride);
        return this.fts.write(req);
    }

    public AppendResponseDocument append(byte[] data) throws Exception {
        AppendDocument req = AppendDocument.Factory.newInstance();
        AppendDocument.Append r = req.addNewAppend();
        TransferInformationType ti = r.addNewTransferInformation();
        String mechanism = this.isMTOMEnabled() ? "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom" : "http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/simple";
        ti.set(ByteIO.encode(mechanism, data));
        ti.setTransferMechanism(mechanism);
        return this.fts.append(req);
    }

    @Override
    public void readAllData(OutputStream os) throws IOException {
        this.readAllData(os, this.chunksize);
    }

    public void readAllData(OutputStream os, int chunksize) throws IOException {
        try {
            byte[] data;
            long offset = 0L;
            while ((data = this.read(offset, 1L, chunksize, 0L)) != null && data.length != 0) {
                offset += (long)data.length;
                if (this.progressListener != null) {
                    try {
                        this.progressListener.notifyProgress(Long.valueOf(data.length));
                    }
                    catch (Exception e) {
                        logger.warn("Error reporting progress.", e);
                    }
                    if (this.progressListener.isCancelled()) {
                        throw new ProgressListener.CancelledException("Cancelled.");
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Read " + data.length + " bytes.");
                }
                os.write(data);
                os.flush();
            }
        }
        catch (ProgressListener.CancelledException ce) {
            throw ce;
        }
        catch (Exception e) {
            IOException ioe = new IOException("IO error: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void writeAllData(InputStream source) throws Exception {
        this.writeAllData(source, this.chunksize);
    }

    public void writeAllData(InputStream source, int chunksize) throws Exception {
        block7: {
            byte[] data = new byte[chunksize];
            long total = 0L;
            boolean doAppend = this.append;
            while (true) {
                int l;
                if ((l = source.read(data)) == -1) {
                    if (total == 0L) {
                        this.doWrite(new byte[0], doAppend);
                    }
                    break block7;
                }
                if (l < data.length) {
                    byte[] read = new byte[l];
                    System.arraycopy(data, 0, read, 0, l);
                    this.doWrite(read, doAppend);
                } else {
                    this.doWrite(data, doAppend);
                }
                total += (long)l;
                doAppend = true;
                if (this.progressListener == null) continue;
                try {
                    this.progressListener.notifyProgress(Long.valueOf(l));
                }
                catch (Exception e) {
                    Log.logException("Error reporting progress.", e, logger);
                }
                if (this.progressListener.isCancelled()) break;
            }
            throw new ProgressListener.CancelledException("Cancelled.");
        }
    }

    private void doWrite(byte[] data, boolean append) throws Exception {
        if (append) {
            this.append(data);
        } else {
            this.truncAppend(0L, data);
        }
    }
}

