/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.type.basic.BeanTypeInfo;
import org.codehaus.xfire.aegis.type.basic.BeanTypePropertyInfo;
import org.codehaus.xfire.util.NamespaceHelper;
import org.jdom.Element;

public class XMLBeanTypeInfo
extends BeanTypeInfo {
    private static final Log logger = LogFactory.getLog(XMLBeanTypeInfo.class);
    private List mappings;
    private Map name2PropertyInfo = new HashMap();

    public XMLBeanTypeInfo(Class typeClass, List mappings, String defaultNS) {
        super(typeClass, defaultNS);
        this.mappings = mappings;
    }

    protected boolean registerType(PropertyDescriptor desc) {
        Element e = this.getPropertyElement(desc.getName());
        if (e != null && e.getAttributeValue("type") != null) {
            return false;
        }
        return super.registerType(desc);
    }

    protected void mapProperty(PropertyDescriptor pd) {
        block12: {
            Element e = this.getPropertyElement(pd.getName());
            String style = null;
            QName mappedName = null;
            if (e != null) {
                String ignore = e.getAttributeValue("ignore");
                if (ignore != null && ignore.equals("true")) {
                    return;
                }
                logger.debug("Found mapping for property " + pd.getName());
                style = e.getAttributeValue("style");
                mappedName = NamespaceHelper.createQName(e, e.getAttributeValue("mappedName"), this.getDefaultNamespace());
            }
            if (style == null) {
                style = "element";
            }
            if (mappedName == null) {
                mappedName = this.createMappedName(pd);
            }
            if (e != null) {
                String minOccurs;
                String nillableVal;
                QName mappedType = NamespaceHelper.createQName(e, e.getAttributeValue("typeName"), this.getDefaultNamespace());
                if (mappedType != null) {
                    this.mapTypeName(mappedName, mappedType);
                }
                if ((nillableVal = e.getAttributeValue("nillable")) != null && nillableVal.length() > 0) {
                    this.ensurePropertyInfo(mappedName).setNillable(Boolean.valueOf(nillableVal));
                }
                if ((minOccurs = e.getAttributeValue("minOccurs")) != null && minOccurs.length() > 0) {
                    this.ensurePropertyInfo(mappedName).setMinOccurs(Integer.parseInt(minOccurs));
                }
            }
            try {
                if (style.equals("element")) {
                    this.mapElement(pd.getName(), mappedName);
                    break block12;
                }
                if (style.equals("attribute")) {
                    this.mapAttribute(pd.getName(), mappedName);
                    break block12;
                }
                throw new XFireRuntimeException("Invalid style: " + style);
            }
            catch (XFireRuntimeException ex) {
                ex.prepend("Couldn't create type for property " + pd.getName() + " on " + this.getTypeClass());
                throw ex;
            }
        }
    }

    private Element getPropertyElement(String name2) {
        Iterator itr = this.mappings.iterator();
        while (itr.hasNext()) {
            Element mapping2 = (Element)itr.next();
            List elements = mapping2.getChildren("property");
            for (int i = 0; i < elements.size(); ++i) {
                Element e = (Element)elements.get(i);
                String name = e.getAttributeValue("name");
                if (name == null || !name.equals(name2)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isNillable(QName name) {
        BeanTypePropertyInfo info = this.getPropertyInfo(name);
        if (info != null) {
            return info.isNillable();
        }
        return super.isNillable(name);
    }

    public int getMinOccurs(QName name) {
        BeanTypePropertyInfo info = this.getPropertyInfo(name);
        if (info != null) {
            return info.getMinOccurs();
        }
        return super.getMinOccurs(name);
    }

    private BeanTypePropertyInfo getPropertyInfo(QName name) {
        return (BeanTypePropertyInfo)this.name2PropertyInfo.get(name);
    }

    private BeanTypePropertyInfo ensurePropertyInfo(QName name) {
        BeanTypePropertyInfo result = this.getPropertyInfo(name);
        if (result == null) {
            result = new BeanTypePropertyInfo();
            this.name2PropertyInfo.put(name, result);
        }
        return result;
    }
}

