/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.Principal;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosClientAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KerberosSecurity
extends BinarySecurity {
    private static Log log = LogFactory.getLog(KerberosSecurity.class);
    private SecretKey secretKey;

    public KerberosSecurity(Element elem) throws WSSecurityException {
        this(elem, true);
    }

    public KerberosSecurity(Element elem, boolean bspCompliant) throws WSSecurityException {
        super(elem, bspCompliant);
        String valueType = this.getValueType();
        if (bspCompliant && !"http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(valueType)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType});
        }
    }

    public KerberosSecurity(Document doc) {
        super(doc);
    }

    public boolean isV5ApReq() {
        String type = this.getValueType();
        return "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ1510".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ4120".equals(type);
    }

    public boolean isGssV5ApReq() {
        String type = this.getValueType();
        return "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510".equals(type) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ4120".equals(type);
    }

    public void retrieveServiceTicket(String jaasLoginModuleName, CallbackHandler callbackHandler, String serviceName) throws WSSecurityException {
        KerberosTicket serviceTicket;
        Subject clientSubject;
        Set<Principal> clientPrincipals;
        LoginContext loginContext = null;
        try {
            loginContext = callbackHandler == null ? new LoginContext(jaasLoginModuleName) : new LoginContext(jaasLoginModuleName, callbackHandler);
            loginContext.login();
        }
        catch (LoginException ex) {
            if (log.isDebugEnabled()) {
                log.debug(ex.getMessage(), ex);
            }
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{ex.getMessage()});
        }
        if (log.isDebugEnabled()) {
            log.debug("Successfully authenticated to the TGT");
        }
        if ((clientPrincipals = (clientSubject = loginContext.getSubject()).getPrincipals()).isEmpty()) {
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{"No Client principals found after login"});
        }
        KerberosTicket tgt = this.getKerberosTicket(clientSubject, null);
        KerberosClientAction action = new KerberosClientAction(clientPrincipals.iterator().next(), serviceName);
        byte[] ticket = Subject.doAs(clientSubject, action);
        if (ticket == null) {
            throw new WSSecurityException(0, "kerberosServiceTicketError");
        }
        if (log.isDebugEnabled()) {
            log.debug("Successfully retrieved a service ticket");
        }
        if ((serviceTicket = this.getKerberosTicket(clientSubject, tgt)) != null) {
            this.secretKey = serviceTicket.getSessionKey();
        }
        this.setToken(ticket);
        if ("".equals(this.getValueType())) {
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
        }
    }

    private KerberosTicket getKerberosTicket(Subject clientSubject, KerberosTicket previousTicket) {
        Set<KerberosTicket> privateCredentials = clientSubject.getPrivateCredentials(KerberosTicket.class);
        if (privateCredentials == null || privateCredentials.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Kerberos client subject private credentials are null");
            }
            return null;
        }
        for (KerberosTicket privateCredential : privateCredentials) {
            if (((Object)privateCredential).equals(previousTicket)) continue;
            return privateCredential;
        }
        return null;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public static boolean isKerberosToken(String valueType) {
        return "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ1510".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ4120".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ4120".equals(valueType);
    }
}

