/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.Principal;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosClientAction
implements PrivilegedAction<byte[]> {
    private static Log log = LogFactory.getLog(KerberosClientAction.class);
    private Principal clientPrincipal;
    private String serviceName;

    public KerberosClientAction(Principal clientPrincipal, String serviceName) {
        this.clientPrincipal = clientPrincipal;
        this.serviceName = serviceName;
    }

    @Override
    public byte[] run() {
        try {
            GSSManager gssManager = GSSManager.getInstance();
            Oid kerberos5Oid = new Oid("1.2.840.113554.1.2.2");
            GSSName gssClient = gssManager.createName(this.clientPrincipal.getName(), GSSName.NT_USER_NAME);
            GSSCredential credentials = gssManager.createCredential(gssClient, 0, kerberos5Oid, 1);
            GSSName gssService = gssManager.createName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext secContext = gssManager.createContext(gssService, kerberos5Oid, credentials, 0);
            secContext.requestMutualAuth(false);
            byte[] token = new byte[]{};
            byte[] returnedToken = secContext.initSecContext(token, 0, token.length);
            secContext.dispose();
            return returnedToken;
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error in obtaining a Kerberos token", e);
            }
            return null;
        }
    }
}

