/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.apache.ws.security.saml.WSSecSignatureSAML;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Document;

public class SAMLTokenSignedAction
implements Action {
    private static Log log = LogFactory.getLog(SAMLTokenSignedAction.class);

    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        Crypto crypto;
        block9: {
            crypto = null;
            try {
                crypto = handler.loadSignatureCrypto(reqData);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block9;
                log.debug(t.getMessage(), t);
            }
        }
        SAMLIssuer saml = this.loadSamlIssuer(handler, reqData);
        AssertionWrapper assertion = saml.newAssertion();
        if (assertion == null) {
            throw new WSSecurityException("WSHandler: Signed SAML: no SAML token received");
        }
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(reqData.getWssConfig());
        CallbackHandler callbackHandler = handler.getPasswordCallbackHandler(reqData);
        WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getUsername(), actionToDo, callbackHandler, reqData);
        wsSign.setUserInfo(reqData.getUsername(), passwordCallback.getPassword());
        if (reqData.getSigKeyId() != 0) {
            wsSign.setKeyIdentifierType(reqData.getSigKeyId());
        }
        if (reqData.getSigAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(reqData.getSigAlgorithm());
        }
        if (reqData.getSigDigestAlgorithm() != null) {
            wsSign.setDigestAlgo(reqData.getSigDigestAlgorithm());
        }
        if (reqData.getSignatureParts().size() > 0) {
            wsSign.setParts(reqData.getSignatureParts());
        }
        try {
            wsSign.build(doc, crypto, assertion, saml.getIssuerCrypto(), saml.getIssuerKeyName(), saml.getIssuerKeyPassword(), reqData.getSecHeader());
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("Error when signing the SAML token: ", e);
        }
    }

    protected SAMLIssuer loadSamlIssuer(WSHandler handler, RequestData reqData) throws WSSecurityException {
        String samlPropFile = handler.getString("samlPropFile", reqData.getMsgContext());
        SAMLIssuer samlIssuer = SAMLIssuerFactory.getInstance(samlPropFile);
        CallbackHandler callbackHandler = handler.getCallbackHandler("samlCallbackClass", "samlCallbackRef", reqData);
        if (callbackHandler != null) {
            samlIssuer.setCallbackHandler(callbackHandler);
        }
        return samlIssuer;
    }
}

