/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FilterIterator
implements SequenceIterator {
    protected SequenceIterator base;
    protected Expression filter;
    private int position = 0;
    private Item current = null;
    protected XPathContext filterContext;

    public FilterIterator(SequenceIterator base, Expression filter, XPathContext context) {
        this.base = base;
        this.filter = filter;
        this.filterContext = context.newMinorContext();
        this.filterContext.setCurrentIterator(base);
        this.filterContext.setOriginatingConstructType(2024);
    }

    public Item next() throws XPathException {
        this.current = this.getNextMatchingItem();
        this.position = this.current == null ? -1 : ++this.position;
        return this.current;
    }

    protected Item getNextMatchingItem() throws XPathException {
        Item next;
        do {
            if ((next = this.base.next()) != null) continue;
            return null;
        } while (!this.matches());
        return next;
    }

    protected boolean matches() throws XPathException {
        SequenceIterator iterator = this.filter.iterate(this.filterContext);
        Item first = iterator.next();
        if (first == null) {
            return false;
        }
        if (first instanceof NodeInfo) {
            return true;
        }
        if (first instanceof BooleanValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a boolean");
            }
            return ((BooleanValue)first).getBooleanValue();
        }
        if (first instanceof StringValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a string");
            }
            return first.getStringValueCS().length() != 0;
        }
        if (first instanceof Int64Value) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return ((Int64Value)first).longValue() == (long)this.base.position();
        }
        if (first instanceof NumericValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return ((NumericValue)first).compareTo(this.base.position()) == 0;
        }
        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, or string");
        return false;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return new FilterIterator(this.base.getAnother(), this.filter, this.filterContext);
    }

    public int getProperties() {
        return 0;
    }

    public static final class Leading
    extends FilterIterator {
        public Leading(SequenceIterator base, Expression filter, XPathContext context) {
            super(base, filter, context);
        }

        protected boolean matches() throws XPathException {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }

        protected Item getNextMatchingItem() throws XPathException {
            Item next = this.base.next();
            if (next == null) {
                return null;
            }
            if (this.matches()) {
                return next;
            }
            return null;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new Leading(this.base.getAnother(), this.filter, this.filterContext);
        }
    }

    public static final class NonNumeric
    extends FilterIterator {
        public NonNumeric(SequenceIterator base, Expression filter, XPathContext context) {
            super(base, filter, context);
        }

        protected boolean matches() throws XPathException {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }

        public SequenceIterator getAnother() throws XPathException {
            return new NonNumeric(this.base.getAnother(), this.filter, this.filterContext);
        }
    }
}

