/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.jetty;

import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.jetty.HttpServerProperties;
import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jetty.servlets.GzipFilter;

public class ConfigurableGzipFilter
extends GzipFilter {
    private HttpServerProperties properties;

    public ConfigurableGzipFilter(HttpServerProperties properties) {
        this.properties = properties;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this._minGzipSize = 65535;
        super.init(new MyFilterConfig(filterConfig));
    }

    private class MyFilterConfig
    implements FilterConfig {
        private FilterConfig config;

        public MyFilterConfig(FilterConfig config) {
            this.config = config;
        }

        @Override
        public String getFilterName() {
            return this.config.getFilterName();
        }

        @Override
        public String getInitParameter(String name) {
            String val = this.config.getInitParameter(name);
            if (val == null) {
                try {
                    val = ConfigurableGzipFilter.this.properties.getValue("gzip." + name);
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException("BUG: got no value (even default) for: " + name, e);
                }
            }
            return val;
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        @Override
        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }
    }
}

