/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.protocol.Protocol;

public class HttpHostFactory {
    protected final Protocol httpProtocol;
    protected final Protocol httpsProtocol;

    public HttpHostFactory(Protocol httpProtocol, Protocol httpsProtocol) {
        this.httpProtocol = httpProtocol;
        this.httpsProtocol = httpsProtocol;
    }

    public HttpHost getHost(HostConfiguration old, String scheme, String host, int port) {
        return new HttpHost(host, port, this.getProtocol(old, scheme, host, port));
    }

    protected Protocol getProtocol(HostConfiguration old, String scheme, String host, int port) {
        Protocol newProtocol;
        String oldScheme;
        Protocol oldProtocol = old.getProtocol();
        if (oldProtocol != null && ((oldScheme = oldProtocol.getScheme()) == scheme || oldScheme != null && oldScheme.equalsIgnoreCase(scheme))) {
            return oldProtocol;
        }
        Protocol protocol = newProtocol = scheme != null && scheme.toLowerCase().endsWith("s") ? this.httpsProtocol : this.httpProtocol;
        if (newProtocol == null) {
            newProtocol = Protocol.getProtocol(scheme);
        }
        return newProtocol;
    }
}

