/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.jparss;

import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.jparss.PInputStream;
import eu.unicore.uftp.jparss.POutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class PBaseSocket
extends Socket {
    private static final Logger logger = Logger.getLogger(PBaseSocket.class);
    final byte[] key;
    protected int id_ = 0;
    protected Socket[] sockets_ = null;
    protected int numStreams_ = 0;

    public PBaseSocket(byte[] key) {
        this.key = key;
    }

    public int getNumStreams() {
        return this.numStreams_;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream[] tinputs = new InputStream[this.numStreams_];
        for (int i = 0; i < this.numStreams_; ++i) {
            InputStream source = this.sockets_[i].getInputStream();
            tinputs[i] = this.key != null ? Utils.getDecryptStream(source, this.key) : source;
        }
        if (this.key != null) {
            logger.info("Reading encrypted data using: " + Utils.md5(this.key));
        }
        PInputStream input = new PInputStream(tinputs);
        return input;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream[] toutputs = new OutputStream[this.numStreams_];
        for (int i = 0; i < this.numStreams_; ++i) {
            OutputStream sink = this.sockets_[i].getOutputStream();
            toutputs[i] = this.key != null ? Utils.getEncryptStream(sink, this.key) : sink;
        }
        if (this.key != null) {
            logger.info("Writing encrypted data using: " + Utils.md5(this.key));
        }
        POutputStream output = new POutputStream(toutputs);
        return output;
    }

    @Override
    public InetAddress getInetAddress() {
        throw new IllegalStateException("This is a parallel socket");
    }

    @Override
    public InetAddress getLocalAddress() {
        throw new IllegalStateException("This is a parallel socket");
    }

    @Override
    public int getPort() {
        throw new IllegalStateException("This is a parallel socket");
    }

    @Override
    public int getLocalPort() {
        throw new IllegalStateException("This is a parallel socket");
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].setTcpNoDelay(on);
            }
        }
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        boolean nodelay = true;
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                nodelay &= this.sockets_[i].getTcpNoDelay();
            }
        }
        return nodelay;
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].setSoLinger(on, linger);
            }
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        if (this.sockets_ != null && this.sockets_.length > 0) {
            return this.sockets_[0].getSoLinger();
        }
        return -1;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].setSoTimeout(timeout);
            }
        }
    }

    @Override
    public int getSoTimeout() throws SocketException {
        if (this.sockets_ != null && this.sockets_.length > 0) {
            return this.sockets_[0].getSoTimeout();
        }
        return 0;
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].setSendBufferSize(size);
            }
        }
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].getSendBufferSize();
            }
        }
        return 0;
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].setReceiveBufferSize(size);
            }
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].getReceiveBufferSize();
            }
        }
        return 0;
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].setKeepAlive(on);
            }
        }
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        boolean keepalive = true;
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                keepalive &= this.sockets_[i].getKeepAlive();
            }
        }
        return keepalive;
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].shutdownInput();
            }
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.sockets_ != null) {
            for (int i = 0; i < this.numStreams_; ++i) {
                this.sockets_[i].shutdownOutput();
            }
        }
    }
}

