/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.canl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.unicore.util.Log;
import org.apache.log4j.Logger;

public class LoggingStoreUpdateListener
implements StoreUpdateListener {
    private static final Logger log = Log.getLogger("unicore.security", LoggingStoreUpdateListener.class);

    @Override
    public void loadingNotification(String location, String type, StoreUpdateListener.Severity level, Exception cause) {
        StringBuilder sb = new StringBuilder();
        sb.append(type).append(" from location ").append(location);
        if (level == StoreUpdateListener.Severity.NOTIFICATION) {
            if (log.isDebugEnabled()) {
                sb.insert(0, "Loaded ");
                log.debug(sb.toString());
            }
            return;
        }
        sb.insert(0, "Problem loading ");
        if (cause != null) {
            sb.append(": ");
            if (Exception.class.equals(cause.getClass()) && cause.getMessage() != null) {
                sb.append(cause.getMessage());
            } else {
                sb.append(cause.toString());
            }
        }
        if (level == StoreUpdateListener.Severity.WARNING) {
            log.warn(sb.toString());
        } else if (cause == null) {
            log.error(sb.toString());
        } else {
            log.error(sb.toString(), cause);
        }
    }
}

