/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.protocol.ExtensionsType;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseType;

public class NameIDMappingResponse
extends AbstractStatusResponse {
    private NameIDMappingResponseType respXml;
    private NameIDMappingResponseDocument xbdoc;

    public NameIDMappingResponse(NameIDMappingResponseDocument src) throws SAMLParseException {
        super(src.getNameIDMappingResponse());
        this.xbdoc = src;
        this.respXml = src.getNameIDMappingResponse();
    }

    public NameIDMappingResponse(NameID issuer, String inResponseTo, NameID mapped) {
        this.xbdoc = NameIDMappingResponseDocument.Factory.newInstance();
        this.respXml = this.xbdoc.addNewNameIDMappingResponse();
        this.init(this.respXml, issuer, inResponseTo);
        this.respXml.setNameID(mapped.getXBean());
        this.respXml.setStatus(this.getOKStatus());
    }

    public NameIDMappingResponse(NameID issuer, String inResponseTo, SAMLProtocolException error) {
        this.xbdoc = NameIDMappingResponseDocument.Factory.newInstance();
        this.respXml = this.xbdoc.addNewNameIDMappingResponse();
        this.init(this.respXml, issuer, inResponseTo);
        this.respXml.addNewNameID().setNil();
        this.respXml.setStatus(this.getErrorStatus(error));
    }

    public void setExtensions(XmlObject val) {
        ExtensionsType exts = this.respXml.getExtensions();
        if (exts == null) {
            exts = this.respXml.addNewExtensions();
        }
        exts.set(val);
    }

    @Override
    public NameIDMappingResponseDocument getDoc() {
        return this.xbdoc;
    }

    @Override
    public void parse() throws SAMLParseException {
        super.parse();
        if (this.respXml.getEncryptedID() != null) {
            throw new SAMLParseException("Unsupported encrypted nameID received");
        }
        if (this.respXml.getNameID() == null) {
            throw new SAMLParseException("No nameID in response");
        }
    }

    @Override
    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        return this.isCorrectlySigned(key, (Document)this.xbdoc.getDomNode());
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xbdoc = NameIDMappingResponseDocument.Factory.parse(doc);
            this.xmlResp = this.xbdoc.getNameIDMappingResponse();
            this.respXml = this.xbdoc.getNameIDMappingResponse();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }
}

