/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.job.emi;

import eu.emi.es.x2010.x12.adl.ActivityDescriptionDocument;
import eu.emi.es.x2010.x12.adl.ActivityIdentificationDocument;
import eu.emi.es.x2010.x12.adl.ApplicationDocument;
import eu.emi.es.x2010.x12.adl.DataStagingDocument;
import eu.emi.es.x2010.x12.adl.ExecutableType;
import eu.emi.es.x2010.x12.adl.InputFileDocument;
import eu.emi.es.x2010.x12.adl.OperatingSystemDocument;
import eu.emi.es.x2010.x12.adl.OptionType;
import eu.emi.es.x2010.x12.adl.OutputFileDocument;
import eu.emi.es.x2010.x12.adl.ResourcesDocument;
import eu.emi.es.x2010.x12.adl.RuntimeEnvironmentDocument;
import eu.emi.es.x2010.x12.adl.SourceDocument;
import eu.emi.es.x2010.x12.adl.TargetDocument;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.StageIn;
import eu.unicore.hila.job.model.StageOut;
import eu.unicore.hila.job.spi.ModelToNative;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CPUArchitectureType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemTypeEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class ModelToEmiAdl
implements ModelToNative {
    private static final Logger log = Logger.getLogger(ModelToEmiAdl.class);
    protected static final String EMI_ADL = "emi-adl";
    private JobModel model;
    private long lastAdlUpdate = 0L;
    private ActivityDescriptionDocument adl;

    public ModelToEmiAdl(JobModel _model) {
        this.model = _model;
    }

    @Override
    public Object getNative() {
        if (this.lastAdlUpdate < this.model.getLastModified()) {
            this.createAdl();
        }
        if (log.isDebugEnabled()) {
            log.debug("EMI ADL:" + System.getProperty("line.separator") + this.adl.xmlText(new XmlOptions().setSavePrettyPrint()));
        }
        return this.adl;
    }

    private void createAdl() {
        this.adl = ActivityDescriptionDocument.Factory.newInstance();
        ActivityDescriptionDocument.ActivityDescription ad = this.adl.addNewActivityDescription();
        if (this.model.getResources() != null) {
            ResourcesDocument.Resources res = this.transformResources();
            ad.setResources(res);
        }
        if (this.model.getApplicationName() != null) {
            if (ad.getResources() == null) {
                ad.addNewResources();
            }
            RuntimeEnvironmentDocument.RuntimeEnvironment rte = ad.getResources().addNewRuntimeEnvironment();
            rte.setName(this.model.getApplicationName());
            rte.setVersion(this.model.getApplicationVersion());
        }
        ApplicationDocument.Application application = null;
        ExecutableType executable = null;
        if (this.model.getExecutable() != null) {
            application = ad.addNewApplication();
            executable = application.addNewExecutable();
            executable.setPath(this.model.getExecutable());
        }
        if (this.model.getArguments() != null && !this.model.getArguments().isEmpty()) {
            application = this.ensureApplication(ad);
            executable = this.ensureExecutable(ad);
            for (String argument : this.model.getArguments()) {
                executable.addArgument(argument);
            }
        }
        if (this.model.getEnvironment() != null && !this.model.getEnvironment().isEmpty()) {
            executable = this.ensureExecutable(ad);
            for (String envName : this.model.getEnvironment().keySet()) {
                OptionType option = application.addNewEnvironment();
                option.setName(envName);
                option.setValue(this.model.getEnvironment().get(envName));
            }
        }
        DataStagingDocument.DataStaging dataStaging = null;
        if (this.model.getStageIns() != null && !this.model.getStageIns().isEmpty()) {
            dataStaging = this.ensureDataStaging(ad);
            for (StageIn stageIn : this.model.getStageIns()) {
                InputFileDocument.InputFile inputFile = dataStaging.addNewInputFile();
                SourceDocument.Source source = inputFile.addNewSource();
                source.setURI(stageIn.getSourceURI());
                inputFile.setName(stageIn.getFileName());
            }
        }
        if (this.model.getStageOuts() != null && !this.model.getStageOuts().isEmpty()) {
            dataStaging = this.ensureDataStaging(ad);
            for (StageOut stageOut : this.model.getStageOuts()) {
                OutputFileDocument.OutputFile outputFile = dataStaging.addNewOutputFile();
                TargetDocument.Target target = outputFile.addNewTarget();
                target.setURI(stageOut.getTargetURI());
                outputFile.setName(stageOut.getFileName());
            }
        }
        ActivityIdentificationDocument.ActivityIdentification activityId = null;
        if (this.model.getTaskName() != null) {
            activityId = this.ensureActivityIdentification(ad);
            activityId.setName(this.model.getTaskName());
        }
        if (this.model.getApplicationDescription() != null) {
            activityId = this.ensureActivityIdentification(ad);
            activityId.setDescription(this.model.getApplicationDescription());
        }
        if (this.model.getJobDescription() != null) {
            activityId = this.ensureActivityIdentification(ad);
            activityId.setDescription(this.model.getJobDescription());
        }
        if (this.model.getStdout() != null) {
            ad.getApplication().setOutput(this.model.getStdout());
            if (!ad.isSetDataStaging()) {
                ad.addNewDataStaging();
            }
            ad.getDataStaging().addNewOutputFile().setName(this.model.getStdout());
        }
        if (this.model.getStderr() != null) {
            ad.getApplication().setError(this.model.getStderr());
            if (!ad.isSetDataStaging()) {
                ad.addNewDataStaging();
            }
            ad.getDataStaging().addNewOutputFile().setName(this.model.getStderr());
        }
        if (this.model.getStdin() != null) {
            ad.getApplication().setInput(this.model.getStdout());
        }
        this.lastAdlUpdate = System.currentTimeMillis();
    }

    private ResourcesDocument.Resources transformResources() {
        ResourcesType jsdlRes = this.model.getResources();
        ResourcesDocument.Resources res = ResourcesDocument.Resources.Factory.newInstance();
        if (jsdlRes.isSetCandidateHosts()) {
            log.warn("Cannot map CandidateHosts to EMI ADL.");
        }
        if (jsdlRes.isSetCPUArchitecture()) {
            res.setPlatform(this.mapPlatform(jsdlRes.getCPUArchitecture()));
        }
        if (jsdlRes.isSetExclusiveExecution()) {
            log.warn("Cannot request exclusive execution in EMI ADL.");
        }
        if (jsdlRes.isSetIndividualCPUCount()) {
            // empty if block
        }
        if (jsdlRes.isSetIndividualCPUSpeed()) {
            // empty if block
        }
        if (jsdlRes.isSetIndividualCPUTime()) {
            res.setIndividualCPUTime(BigInteger.valueOf(new Double(jsdlRes.getIndividualCPUTime().getExactArray(0).getDoubleValue()).longValue()));
        }
        if (jsdlRes.isSetIndividualDiskSpace()) {
            res.setDiskSpaceRequirement(BigInteger.valueOf(new Double(jsdlRes.getIndividualDiskSpace().getExactArray(0).getDoubleValue()).longValue()));
        }
        if (jsdlRes.isSetIndividualNetworkBandwidth()) {
            // empty if block
        }
        if (jsdlRes.isSetOperatingSystem()) {
            res.setOperatingSystemArray(0, this.mapOS(jsdlRes.getOperatingSystem()));
        }
        if (jsdlRes.isSetIndividualPhysicalMemory()) {
            res.setIndividualPhysicalMemory(BigInteger.valueOf(new Double(jsdlRes.getIndividualPhysicalMemory().getExactArray(0).getDoubleValue()).longValue()));
        }
        if (jsdlRes.isSetIndividualVirtualMemory()) {
            res.setIndividualVirtualMemory(BigInteger.valueOf(new Double(jsdlRes.getIndividualVirtualMemory().getExactArray(0).getDoubleValue()).longValue()));
        }
        if (jsdlRes.isSetTotalCPUCount()) {
            // empty if block
        }
        return res;
    }

    private String mapPlatform(CPUArchitectureType cpuArchitecture) {
        switch (cpuArchitecture.getCPUArchitectureName().intValue()) {
            case 5: {
                return "amd64";
            }
            case 8: {
                return "itanium";
            }
            case 3: 
            case 4: {
                return "i386";
            }
            case 2: {
                return "powerpc";
            }
            case 1: {
                return "sparc";
            }
        }
        return cpuArchitecture.getCPUArchitectureName().toString();
    }

    private OperatingSystemDocument.OperatingSystem mapOS(OperatingSystemType operatingSystem) {
        OperatingSystemDocument.OperatingSystem os = OperatingSystemDocument.OperatingSystem.Factory.newInstance();
        switch (operatingSystem.getOperatingSystemType().getOperatingSystemName().intValue()) {
            case 36: {
                os.setName(OperatingSystemTypeEnumeration.LINUX.toString());
                os.setFamily("linux");
                os.setVersion(operatingSystem.getOperatingSystemVersion());
                break;
            }
            case 2: {
                os.setName(OperatingSystemTypeEnumeration.MACOS.toString());
                os.setFamily("macosx");
                os.setVersion(operatingSystem.getOperatingSystemVersion());
                break;
            }
            case 29: {
                os.setName(OperatingSystemTypeEnumeration.SOLARIS.toString());
                os.setFamily("solaris");
                os.setVersion(operatingSystem.getOperatingSystemVersion());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 58: 
            case 63: 
            case 67: {
                os.setName(operatingSystem.getOperatingSystemType().getOperatingSystemName().toString());
                os.setVersion(operatingSystem.getOperatingSystemVersion());
                os.setFamily("windows");
            }
            default: {
                os.setName(operatingSystem.getOperatingSystemType().getOperatingSystemName().toString());
                os.setVersion(operatingSystem.getOperatingSystemVersion());
            }
        }
        return os;
    }

    private ActivityIdentificationDocument.ActivityIdentification ensureActivityIdentification(ActivityDescriptionDocument.ActivityDescription ad) {
        if (ad.getActivityIdentification() == null) {
            return ad.addNewActivityIdentification();
        }
        return ad.getActivityIdentification();
    }

    private DataStagingDocument.DataStaging ensureDataStaging(ActivityDescriptionDocument.ActivityDescription ad) {
        if (ad.getDataStaging() == null) {
            return ad.addNewDataStaging();
        }
        return ad.getDataStaging();
    }

    private ExecutableType ensureExecutable(ActivityDescriptionDocument.ActivityDescription ad) {
        this.ensureApplication(ad);
        if (ad.getApplication().getExecutable() == null) {
            return ad.getApplication().addNewExecutable();
        }
        return ad.getApplication().getExecutable();
    }

    private ApplicationDocument.Application ensureApplication(ActivityDescriptionDocument.ActivityDescription ad) {
        if (ad.getApplication() == null) {
            return ad.addNewApplication();
        }
        return ad.getApplication();
    }

    public String getFormatName() {
        return EMI_ADL;
    }
}

