/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.unicore.emi.es.clients.ActivityInfoClient;
import eu.unicore.emi.es.clients.ActivityManagementClient;
import eu.unicore.emi.es.clients.CreateActivityClient;
import eu.unicore.hila.Location;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.emi.es.EmiEsProperties;
import eu.unicore.hila.grid.emi.es.SiteServices;
import eu.unicore.util.httpclient.ClientProperties;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class EmirSiteDiscovery
implements Callable<List<Site>> {
    private final EMIRClient emirClient;
    private EmiEsProperties props;

    public EmirSiteDiscovery(EMIRClient _client, EmiEsProperties _props) {
        this.emirClient = _client;
        this.props = _props;
    }

    @Override
    public List<Site> call() throws Exception {
        ArrayList<Site> sites = new ArrayList<Site>();
        MultivaluedMapImpl params1 = new MultivaluedMapImpl();
        params1.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), "org.ogf.glue.emies.activitycreation");
        JSONArray createActivityEntries = this.emirClient.queryByQueryParams(params1);
        HashMap<String, SiteServices> sitesServices = new HashMap<String, SiteServices>();
        for (int i = 0; i < createActivityEntries.length() - 1; ++i) {
            JSONObject createActivityEntry = createActivityEntries.getJSONObject(i);
            String serviceId = createActivityEntry.getString(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName());
            String createActivityServiceUrl = createActivityEntry.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
            MultivaluedMapImpl params2 = new MultivaluedMapImpl();
            params2.add(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), serviceId);
            params2.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), "org.ogf.glue.emies.activitymanagement");
            JSONArray activityMgmtEntries = this.emirClient.queryByQueryParams(params2);
            String amURL = activityMgmtEntries.getJSONObject(0).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
            MultivaluedMapImpl params3 = new MultivaluedMapImpl();
            params3.add(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), serviceId);
            params3.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), "org.ogf.glue.emies.activityinfo");
            JSONArray activityInfoEntries = this.emirClient.queryByQueryParams(params3);
            String aiURL = activityInfoEntries.getJSONObject(0).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
            SiteServices singleSiteServices = new SiteServices();
            singleSiteServices.setCreateActivityService(createActivityServiceUrl);
            singleSiteServices.setActivityInfoService(aiURL);
            singleSiteServices.setActivityMgmtService(amURL);
            sitesServices.put(serviceId, singleSiteServices);
            URL siteURL = new URL(createActivityServiceUrl);
            String siteName = siteURL.getHost();
            Location siteLoc = new Location("emi-es:/sites").getChildLocation(siteName);
            ClientProperties sp = new ClientProperties(this.props);
            ActivityInfoClient aiClient = new ActivityInfoClient(aiURL, sp);
            ActivityManagementClient amClient = new ActivityManagementClient(amURL, sp);
            CreateActivityClient caClient = new CreateActivityClient(createActivityServiceUrl, sp);
            Site site = (Site)siteLoc.locate(aiClient, amClient, caClient);
            sites.add(site);
        }
        return sites;
    }
}

