/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import eu.unicore.hila.grid.ID;
import eu.unicore.hila.grid.emi.es.EmiEsProperties;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import org.apache.log4j.Logger;

public class EmiEsSecurityProperties
extends ClientProperties
implements IClientConfiguration,
ID {
    private static final Logger log = Logger.getLogger(EmiEsSecurityProperties.class);
    public static final String HILA_EMI_ES_BASE = "hila.emi.es";
    public static final String TRUSTSTORE = ".truststore";
    public static final String TRUSTSTORETYPE = ".truststoretype";
    public static final String TRUSTSTOREPASSWORD = ".truststorepassword";
    public static final String KEYSTORETYPE = ".keystoretype";
    public static final String PASSWORD = ".password";
    private static final String KEYPASSWORD = ".keypassword";
    public static final String ALIAS = ".alias";
    public static final String KEYSTORE = ".keystore";
    private static final String HILAUNICORE6_PROFILE_BASE = "hila.emi.es.profile";
    private EmiEsProperties properties;
    private String profile;
    private String profileBase;

    public EmiEsSecurityProperties(EmiEsProperties _props, String _profile) {
        super(_props);
        this.properties = _props;
        this.profile = _profile;
        if (log.isDebugEnabled()) {
            log.debug("profile == " + this.profile);
        }
        if (this.profile == null) {
            if (log.isDebugEnabled()) {
                log.debug("Using default profile");
            }
            this.profileBase = HILA_EMI_ES_BASE;
        } else {
            this.profileBase = "hila.emi.es.profile." + this.profile;
            if (log.isDebugEnabled()) {
                log.debug("Using profile base " + this.profileBase);
            }
        }
    }

    public EmiEsSecurityProperties(EmiEsProperties _props) {
        this(_props, null);
    }

    @Override
    public boolean isSslEnabled() {
        return true;
    }

    @Override
    public EmiEsSecurityProperties clone() {
        try {
            EmiEsSecurityProperties u6prop = (EmiEsSecurityProperties)super.clone();
            u6prop.profile = this.profile != null ? new String(this.profile) : null;
            u6prop.properties = (EmiEsProperties)this.properties.clone();
            u6prop.profileBase = this.profileBase != null ? new String(this.profileBase) : null;
            return u6prop;
        }
        catch (Exception e) {
            log.error("Exception in clone()", e);
            return this;
        }
    }
}

