/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.emi.es;

import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.emi.es.EmiEsConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class EmiEsProperties
extends Properties {
    private static final long serialVersionUID = 1760098679687339488L;
    private static final String EMI_ES_PROP_BASE = "hila.emi.es";
    private static final String EMI_ES_ENDPOINT_BASE = "hila.emi.es.endpoint.base";
    private static final String EMI_ES_KEYSTORE = "hila.emi.es.keystore";
    private static final String EMI_ES_KEYSTORE_FILE = "hila.emi.es.keystore.file";
    private static final String EMI_ES_KEYSTORE_ALIAS = "hila.emi.es.keystore.alias";
    private static final String EMI_ES_KEYSTORE_PASSWORD = "hila.emi.es.keystore.password";
    private static final String EMI_ES_KEYSTORE_TYPE = "hila.emi.es.keystore.type";
    private static final String EMI_ES_SVC_CREATION = "hila.emi.es.creationName";
    private static final String EMI_ES_SVC_AI = "hila.emi.es.infoName";
    private static final String EMI_ES_SVC_AMGMT = "hila.emi.es.mgmtName";
    private static final String EMI_EMIR_ENDPOINT = "hila.emi.es.emir";
    private File configBase = null;

    public File getConfigBase() {
        return this.configBase;
    }

    public void setConfigBase(File _configBase) {
        this.configBase = _configBase;
    }

    public List<String> getSiteEndpoints() {
        ArrayList<String> siteEndpoints = new ArrayList<String>();
        for (Object key : this.keySet()) {
            String string;
            if (!(key instanceof String) || !(string = (String)key).contains(EMI_ES_ENDPOINT_BASE)) continue;
            siteEndpoints.add(this.getProperty((String)key));
        }
        return siteEndpoints;
    }

    public List<String> getEmirEndpoints() {
        ArrayList<String> emirEndpoints = new ArrayList<String>();
        for (Object key : this.keySet()) {
            String string = (String)key;
            if (!string.contains(EMI_EMIR_ENDPOINT)) continue;
            emirEndpoints.add(this.getProperty((String)key));
        }
        return emirEndpoints;
    }

    @Override
    public synchronized boolean equals(Object _other) {
        if (!(_other instanceof EmiEsProperties)) {
            return false;
        }
        EmiEsProperties emiProps = (EmiEsProperties)_other;
        if (this.configBase != null) {
            if (emiProps.configBase != null) {
                return super.equals(_other) && this.configBase.equals(emiProps.configBase);
            }
            return false;
        }
        if (emiProps.configBase != null) {
            return false;
        }
        return super.equals(_other);
    }

    @Override
    public synchronized int hashCode() {
        if (this.configBase != null) {
            return 1326887 * this.configBase.hashCode() + super.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public synchronized Object clone() {
        EmiEsProperties emiProps = (EmiEsProperties)super.clone();
        emiProps.configBase = this.configBase;
        return emiProps;
    }

    public Config getConfig() {
        return new EmiEsConfig(this);
    }

    public String getCreationServiceName() {
        return this.getProperty(EMI_ES_SVC_CREATION, "CreateActivityService");
    }

    public String getActivityInfoServiceName() {
        return this.getProperty(EMI_ES_SVC_AI, "ActivityInfoService");
    }

    public String getActivityManagementServiceName() {
        return this.getProperty(EMI_ES_SVC_AMGMT, "ActivityManagementService");
    }

    public String getEmirEndpoint() {
        return this.getProperty(EMI_EMIR_ENDPOINT);
    }
}

